/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.api.space.thread;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tardis.api.space.IOxygenSealer;
import net.tardis.api.space.OxygenHelper;

public class OxygenThread
extends Thread {
    private int maxTries;
    private IOxygenSealer tile;
    private World world;
    private BlockPos start;
    private int triesLeft = 2700;
    private List<BlockPos> airPos = new ArrayList<BlockPos>();

    public OxygenThread(World world, BlockPos pos, IOxygenSealer tile, int maxTries) {
        super("TARDIS Mod Oxygen Thread");
        this.tile = tile;
        this.start = pos.func_185334_h();
        this.world = world;
        this.maxTries = maxTries;
    }

    @Override
    public void run() {
        this.triesLeft = this.maxTries;
        this.airPos.clear();
        for (Direction dir : Direction.values()) {
            this.floodFill(this.world, this.start.func_177972_a(dir), dir.func_176734_d());
        }
        if (this.triesLeft > 0) {
            this.world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(0, () -> this.tile.setSealedPositions(this.airPos)));
        } else {
            this.tile.setSealedPositions(new ArrayList<BlockPos>());
        }
    }

    private void floodFill(World world, BlockPos pos, Direction dir) {
        if (this.triesLeft <= 0) {
            return;
        }
        if (OxygenHelper.canOxygenPass(world, world.func_180495_p(pos), pos)) {
            this.airPos.add(pos);
            --this.triesLeft;
            for (Direction d : Direction.values()) {
                if (this.airPos.contains(pos.func_177972_a(d))) continue;
                this.floodFill(world, pos.func_177972_a(d), d.func_176734_d());
            }
        }
    }
}

