/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.api.space;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class OxygenHelper {
    private static File config = new File("./config/tardis-oxygen-config.json");
    private static List<ResourceLocation> permeable = new ArrayList<ResourceLocation>();
    private static List<ResourceLocation> nonpermeable = new ArrayList<ResourceLocation>();

    public static boolean canOxygenPass(World world, BlockState state, BlockPos pos) {
        if (permeable.contains(state.func_177230_c().getRegistryName())) {
            return true;
        }
        if (nonpermeable.contains(state.func_177230_c().getRegistryName())) {
            return false;
        }
        return state.isAir((IBlockReader)world, pos) || !state.func_200132_m() && !(state.func_177230_c() instanceof AbstractGlassBlock);
    }

    public static void readOrCreate() {
        try {
            if (config.exists()) {
                JsonObject doc = new JsonParser().parse((Reader)new FileReader(config)).getAsJsonObject();
                for (JsonElement perm : doc.get("permeable").getAsJsonArray()) {
                    permeable.add(new ResourceLocation(perm.getAsString()));
                }
                for (JsonElement perm : doc.get("nonpermeable").getAsJsonArray()) {
                    nonpermeable.add(new ResourceLocation(perm.getAsString()));
                }
            } else {
                JsonWriter write = new GsonBuilder().setPrettyPrinting().create().newJsonWriter((Writer)new FileWriter(config));
                write.beginObject();
                write.name("permeable_comment");
                write.value("List of Block IDs which allow oxygen to flow through it (permeable). E.g. tardis:ars_egg ");
                write.name("permeable");
                write.beginArray();
                write.endArray();
                write.name("nonpermeable_comment");
                write.value("List of Block IDs which does not allow oxygen to flow through it (nonpermeable) E.g. tardis:oxygen_sealer ");
                write.name("nonpermeable");
                write.beginArray();
                write.endArray();
                write.endObject();
                write.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

