/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.blocks;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import slimeknights.mantle.tileentity.InventoryTileEntity;
import slimeknights.tmechworks.api.disguisestate.DisguiseStates;
import slimeknights.tmechworks.common.blocks.tileentity.RedstoneMachineTileEntity;
import slimeknights.tmechworks.library.Util;

public abstract class RedstoneMachineBlock
extends DirectionalBlock {
    public static final BooleanProperty HAS_DISGUISE = BooleanProperty.func_177716_a((String)"has_disguise");
    public static final IntegerProperty LIGHT_VALUE = IntegerProperty.func_177719_a((String)"light_value", (int)0, (int)15);
    public boolean dropState = true;

    protected RedstoneMachineBlock(Material material) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200943_b(3.5f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HAS_DISGUISE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIGHT_VALUE, (Comparable)Integer.valueOf(0)));
        if (this.hasFacingDirection()) {
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)Direction.NORTH));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        if (this.hasFacingDirection()) {
            builder.func_206894_a(new Property[]{field_176387_N});
        }
        builder.func_206894_a(new Property[]{HAS_DISGUISE});
        builder.func_206894_a(new Property[]{LIGHT_VALUE});
    }

    public boolean openGui(PlayerEntity player, World world, BlockPos pos) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof INamedContainerProvider)) {
                return false;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
        }
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        RedstoneMachineTileEntity logicBase = (RedstoneMachineTileEntity)worldIn.func_175625_s(pos);
        if (logicBase != null) {
            logicBase.updateRedstone();
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean hasFacingDirection() {
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.hasFacingDirection()) {
            return super.func_196258_a(context);
        }
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)field_176387_N, (Comparable)context.func_196010_d().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nonnull LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof InventoryTileEntity) {
            ((InventoryTileEntity)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof RedstoneMachineTileEntity) {
            NonNullList drops = NonNullList.func_191196_a();
            RedstoneMachineTileEntity machine = (RedstoneMachineTileEntity)te;
            ItemStack item = new ItemStack((IItemProvider)this, 1);
            this.writeAdditionalItemData(state, (World)builder.func_216018_a(), new BlockPos((Vector3d)builder.func_216019_b(LootParameters.field_237457_g_)), item);
            if (this.dropState) {
                machine.storeTileData(item);
            }
            drops.add(item);
            return drops;
        }
        return super.func_220076_a(state, builder);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (this.blockMatches(state, worldIn, pos, newState, isMoving)) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof IInventory) {
            if (!this.dropState) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)te));
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void writeAdditionalItemData(BlockState state, World worldIn, BlockPos pos, ItemStack stack) {
    }

    public boolean blockMatches(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return state.func_177230_c() == newState.func_177230_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT compound = stack.func_77978_p();
        if (compound.func_150297_b("BlockEntityTag", 10)) {
            ItemStack disguise;
            CompoundNBT tags = compound.func_74775_l("BlockEntityTag");
            if (tags.func_150297_b("Disguise", 10) && (disguise = ItemStack.func_199557_a((CompoundNBT)tags.func_74775_l("Disguise"))) != ItemStack.field_190927_a) {
                tooltip.add((ITextComponent)new TranslationTextComponent(Util.prefix("hud.disguise")).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
                tooltip.add(disguise.func_200301_q());
            }
            if (tags.func_150297_b("Items", 9)) {
                ListNBT items = tags.func_150295_c("Items", 9);
                if (items.size() > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(Util.prefix("hud.items")).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
                }
                for (int i = 0; i < items.size(); ++i) {
                    CompoundNBT itemTag = items.func_150305_b(i);
                    int slot = itemTag.func_74771_c("Slot") & 0xFF;
                    ItemStack item = ItemStack.func_199557_a((CompoundNBT)itemTag);
                    tooltip.add((ITextComponent)new TranslationTextComponent(Util.prefix("hud.slot"), new Object[]{slot, item.func_200301_q(), item.func_190916_E()}).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
                }
            }
        }
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            this.openGui(player, worldIn, pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public void setDefaultNBT(CompoundNBT nbt, CompoundNBT blockState) {
        blockState.func_74768_a("InventorySize", 0);
    }

    public <T> T runOnDisguiseBlock(BlockState state, IBlockReader worldIn, BlockPos pos, Function<BlockState, T> func, Supplier<T> orElse) {
        RedstoneMachineTileEntity machine;
        ItemStack disguise;
        if (!((Boolean)state.func_177229_b((Property)HAS_DISGUISE)).booleanValue()) {
            return orElse.get();
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof RedstoneMachineTileEntity && (disguise = (machine = (RedstoneMachineTileEntity)te).getDisguiseBlock()).func_77973_b() instanceof BlockItem) {
            BlockState disguiseState = ((BlockItem)disguise.func_77973_b()).func_179223_d().func_176223_P();
            disguiseState = DisguiseStates.processDisguiseStates(disguiseState, ((RedstoneMachineTileEntity)te).getDisguiseState(), (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H));
            return func.apply(disguiseState);
        }
        return orElse.get();
    }

    public boolean func_208619_r() {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.runOnDisguiseBlock(state, worldIn, pos, disguise -> disguise.func_215700_a(worldIn, pos, context), () -> super.func_220053_a(state, worldIn, pos, context));
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.runOnDisguiseBlock(state, worldIn, pos, disguise -> disguise.func_235754_c_(worldIn, pos), () -> super.func_196247_c(state, worldIn, pos));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.runOnDisguiseBlock(state, worldIn, pos, disguise -> disguise.func_215685_b(worldIn, pos, context), () -> super.func_220071_b(state, worldIn, pos, context));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.runOnDisguiseBlock(state, reader, pos, disguise -> disguise.func_200131_a(reader, pos), () -> super.func_200123_i(state, reader, pos));
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.runOnDisguiseBlock(state, worldIn, pos, disguise -> disguise.func_200016_a(worldIn, pos), () -> ((IBlockReader)worldIn).func_201572_C());
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.runOnDisguiseBlock(state, world, pos, disguise -> disguise.getLightValue(world, pos), () -> super.getLightValue(state, world, pos));
    }
}

