/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.backend.model.IBufferedModel;
import com.jozufozu.flywheel.backend.model.IndexedModel;
import com.jozufozu.flywheel.core.model.IModel;
import java.util.function.Supplier;

public class ModelRenderer {
    protected Supplier<IModel> modelSupplier;
    protected IBufferedModel model;
    protected boolean initialized;

    public ModelRenderer(Supplier<IModel> modelSupplier) {
        this.modelSupplier = modelSupplier;
    }

    public void draw() {
        if (!this.initialized) {
            this.init();
        }
        if (!this.isValid()) {
            return;
        }
        this.model.setupState();
        this.model.drawCall();
        this.model.clearState();
    }

    public void delete() {
        if (this.model != null) {
            this.model.delete();
        }
    }

    protected void init() {
        this.initialized = true;
        IModel model = this.modelSupplier.get();
        if (model.empty()) {
            return;
        }
        this.model = new IndexedModel(model);
    }

    protected boolean isValid() {
        return this.model != null && this.model.valid();
    }
}

