/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstanceManager;
import com.jozufozu.flywheel.backend.instancing.tile.TileInstanceManager;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;

public class InstanceWorld {
    protected final MaterialManager<WorldProgram> materialManager = MaterialManager.builder(Contexts.WORLD).build();
    protected final InstanceManager<Entity> entityInstanceManager = new EntityInstanceManager(this.materialManager);
    protected final InstanceManager<TileEntity> tileEntityInstanceManager = new TileInstanceManager(this.materialManager);

    public MaterialManager<WorldProgram> getMaterialManager() {
        return this.materialManager;
    }

    public InstanceManager<Entity> getEntityInstanceManager() {
        return this.entityInstanceManager;
    }

    public InstanceManager<TileEntity> getTileEntityInstanceManager() {
        return this.tileEntityInstanceManager;
    }

    public void delete() {
        this.materialManager.delete();
    }

    public void loadAll(ClientWorld world) {
        world.field_147482_g.forEach(this.tileEntityInstanceManager::add);
        world.func_217416_b().forEach(this.entityInstanceManager::add);
    }

    public void beginFrame(BeginFrameEvent event) {
        this.materialManager.checkAndShiftOrigin(event.getInfo());
        this.tileEntityInstanceManager.beginFrame(event.getInfo());
        this.entityInstanceManager.beginFrame(event.getInfo());
    }

    public void tick() {
        Entity renderViewEntity;
        Minecraft mc = Minecraft.func_71410_x();
        Object object = renderViewEntity = mc.field_175622_Z != null ? mc.field_175622_Z : mc.field_71439_g;
        if (renderViewEntity == null) {
            return;
        }
        this.tileEntityInstanceManager.tick(renderViewEntity.func_226277_ct_(), renderViewEntity.func_226278_cu_(), renderViewEntity.func_226281_cx_());
        this.entityInstanceManager.tick(renderViewEntity.func_226277_ct_(), renderViewEntity.func_226278_cu_(), renderViewEntity.func_226281_cx_());
    }

    public void renderLayer(RenderLayerEvent event) {
        event.type.func_228547_a_();
        this.materialManager.render(event.layer, event.viewProjection, event.camX, event.camY, event.camZ);
        event.type.func_228549_b_();
    }
}

