/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL15;

public abstract class MappedBuffer
extends VecBuffer
implements AutoCloseable {
    protected boolean mapped;
    protected final GlBuffer owner;

    public MappedBuffer(GlBuffer owner) {
        this.owner = owner;
    }

    protected abstract void checkAndMap();

    public void flush() {
        if (this.mapped) {
            GL15.glUnmapBuffer((int)this.owner.type.glEnum);
            this.mapped = false;
            this.setInternal(null);
        }
    }

    @Override
    public void close() throws Exception {
        this.flush();
    }

    @Override
    public MappedBuffer putFloatArray(float[] floats) {
        this.checkAndMap();
        super.putFloatArray(floats);
        return this;
    }

    @Override
    public MappedBuffer putByteArray(byte[] bytes) {
        this.checkAndMap();
        super.putByteArray(bytes);
        return this;
    }

    @Override
    public MappedBuffer position(int p) {
        this.checkAndMap();
        super.position(p);
        return this;
    }

    @Override
    public MappedBuffer putFloat(float f) {
        this.checkAndMap();
        super.putFloat(f);
        return this;
    }

    @Override
    public MappedBuffer putInt(int i) {
        this.checkAndMap();
        super.putInt(i);
        return this;
    }

    @Override
    public MappedBuffer put(byte b) {
        this.checkAndMap();
        super.put(b);
        return this;
    }

    @Override
    public MappedBuffer put(ByteBuffer b) {
        this.checkAndMap();
        super.put(b);
        return this;
    }

    @Override
    public MappedBuffer putVec4(float x, float y, float z, float w) {
        this.checkAndMap();
        super.putVec4(x, y, z, w);
        return this;
    }

    @Override
    public MappedBuffer putVec3(float x, float y, float z) {
        this.checkAndMap();
        super.putVec3(x, y, z);
        return this;
    }

    @Override
    public MappedBuffer putVec2(float x, float y) {
        this.checkAndMap();
        super.putVec2(x, y);
        return this;
    }

    @Override
    public MappedBuffer putVec3(byte x, byte y, byte z) {
        this.checkAndMap();
        super.putVec3(x, y, z);
        return this;
    }

    @Override
    public MappedBuffer putVec2(byte x, byte y) {
        this.checkAndMap();
        super.putVec2(x, y);
        return this;
    }
}

