/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.List;
import java.util.function.Function;
import mekanism.api.DataHandlerUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;

public enum SubstanceType {
    ENERGY("EnergyContainers", tile -> tile.getEnergyContainers(null)),
    FLUID("FluidTanks", tile -> tile.getFluidTanks(null)),
    GAS("GasTanks", tile -> tile.getGasTanks(null)),
    INFUSION("InfusionTanks", tile -> tile.getInfusionTanks(null)),
    PIGMENT("PigmentTanks", tile -> tile.getPigmentTanks(null)),
    SLURRY("SlurryTanks", tile -> tile.getSlurryTanks(null)),
    HEAT("HeatCapacitors", tile -> tile.getHeatCapacitors(null));

    private final String containerTag;
    private final Function<TileEntityMekanism, List<? extends INBTSerializable<CompoundNBT>>> containerSupplier;

    private SubstanceType(String containerTag, Function<TileEntityMekanism, List<? extends INBTSerializable<CompoundNBT>>> containerSupplier) {
        this.containerTag = containerTag;
        this.containerSupplier = containerSupplier;
    }

    public void write(TileEntityMekanism tile, CompoundNBT tag) {
        tag.func_218657_a(this.containerTag, (INBT)DataHandlerUtils.writeContainers(this.containerSupplier.apply(tile)));
    }

    public void read(TileEntityMekanism tile, CompoundNBT tag) {
        DataHandlerUtils.readContainers(this.containerSupplier.apply(tile), tag.func_150295_c(this.containerTag, 10));
    }

    public String getContainerTag() {
        return this.containerTag;
    }

    public List<? extends INBTSerializable<CompoundNBT>> getContainers(TileEntityMekanism tile) {
        return this.containerSupplier.apply(tile);
    }

    public boolean canHandle(TileEntityMekanism tile) {
        switch (this) {
            case ENERGY: {
                return tile.canHandleEnergy();
            }
            case FLUID: {
                return tile.canHandleFluid();
            }
            case GAS: {
                return tile.canHandleGas();
            }
            case INFUSION: {
                return tile.canHandleInfusion();
            }
            case PIGMENT: {
                return tile.canHandlePigment();
            }
            case SLURRY: {
                return tile.canHandleSlurry();
            }
            case HEAT: {
                return tile.canHandleHeat();
            }
        }
        return false;
    }
}

