/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.FluidTankFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.upgrade.FluidTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFluidTank
extends TileEntityMekanism
implements IConfigurable,
IFluidContainerManager {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"})
    public FluidTankFluidTank fluidTank;
    private IFluidContainerManager.ContainerEditMode editMode = IFluidContainerManager.ContainerEditMode.BOTH;
    public FluidTankTier tier;
    public int valve;
    @Nonnull
    public FluidStack valveFluid = FluidStack.EMPTY;
    public float prevScale;
    private boolean needsPacket;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private OutputInventorySlot outputSlot;
    private boolean updateClientLight = false;

    public TileEntityFluidTank(IBlockProvider blockProvider) {
        super(blockProvider);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.tier = Attribute.getTier(this.getBlockType(), FluidTankTier.class);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = FluidTankFluidTank.create(this);
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = FluidInventorySlot.input(this.fluidTank, this, 146, 19);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 146, 51);
        builder.addSlot(this.outputSlot);
        this.inputSlot.setSlotOverlay(SlotOverlay.INPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.OUTPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.updateClientLight) {
            WorldUtils.recheckLighting((IBlockDisplayReader)this.field_145850_b, this.field_174879_c);
            this.updateClientLight = false;
        }
    }

    @Override
    protected void onUpdateServer() {
        float scale;
        super.onUpdateServer();
        if (this.valve > 0) {
            --this.valve;
            if (this.valve == 0) {
                this.valveFluid = FluidStack.EMPTY;
                this.needsPacket = true;
            }
        }
        if ((scale = MekanismUtils.getScale(this.prevScale, this.fluidTank)) != this.prevScale) {
            if (this.prevScale == 0.0f || scale == 0.0f) {
                WorldUtils.recheckLighting((IBlockDisplayReader)this.field_145850_b, this.field_174879_c);
            }
            this.prevScale = scale;
            this.needsPacket = true;
        }
        this.inputSlot.handleTank(this.outputSlot, this.editMode);
        if (this.getActive()) {
            FluidUtils.emit(Collections.singleton(Direction.DOWN), this.fluidTank, this, this.tier.getOutput());
        }
        if (this.needsPacket) {
            this.sendUpdatePacket();
            this.needsPacket = false;
        }
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74768_a("editMode", this.editMode.ordinal());
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setEnumIfPresent(data, "editMode", IFluidContainerManager.ContainerEditMode::byIndexStatic, mode -> {
            this.editMode = mode;
        });
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    @Nonnull
    public FluidStack insertFluid(int tank, @Nonnull FluidStack stack, @Nullable Direction side, @Nonnull Action action) {
        FluidStack remainder = super.insertFluid(tank, stack, side, action);
        if (side == Direction.UP && action.execute() && remainder.getAmount() < stack.getAmount() && !this.isRemote()) {
            if (this.valve == 0) {
                this.needsPacket = true;
            }
            this.valve = 20;
            this.valveFluid = new FluidStack(stack, 1);
        }
        return remainder;
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            World world = this.func_145831_w();
            if (world != null) {
                world.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    @ComputerMethod
    public IFluidContainerManager.ContainerEditMode getContainerEditMode() {
        return this.editMode;
    }

    @Override
    public void nextMode() {
        this.editMode = (IFluidContainerManager.ContainerEditMode)this.editMode.getNext();
        this.markDirty(false);
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof FluidTankUpgradeData) {
            FluidTankUpgradeData data = (FluidTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.inputSlot.setStack(data.inputSlot.getStack());
            this.outputSlot.setStack(data.outputSlot.getStack());
            this.editMode = data.editMode;
            this.fluidTank.setStack(data.stored);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public FluidTankUpgradeData getUpgradeData() {
        return new FluidTankUpgradeData(this.redstone, this.inputSlot, this.outputSlot, this.editMode, this.fluidTank.getFluid(), this.getComponents());
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(IFluidContainerManager.ContainerEditMode::byIndexStatic, IFluidContainerManager.ContainerEditMode.BOTH, () -> this.editMode, value -> {
            this.editMode = value;
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("fluid", (INBT)this.fluidTank.getFluid().writeToNBT(new CompoundNBT()));
        updateTag.func_218657_a("valve", (INBT)this.valveFluid.writeToNBT(new CompoundNBT()));
        updateTag.func_74776_a("scale", this.prevScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setFluidStackIfPresent(tag, "fluid", fluid -> this.fluidTank.setStack((FluidStack)fluid));
        NBTUtils.setFluidStackIfPresent(tag, "valve", fluid -> {
            this.valveFluid = fluid;
        });
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            if (this.prevScale != scale) {
                if (this.prevScale == 0.0f || scale == 0.0f) {
                    this.updateClientLight = true;
                }
                this.prevScale = scale;
            }
        });
    }

    @ComputerMethod
    private void setContainerEditMode(IFluidContainerManager.ContainerEditMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.editMode != mode) {
            this.editMode = mode;
            this.markDirty(false);
        }
    }

    @ComputerMethod
    private void incrementContainerEditMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode();
    }

    @ComputerMethod
    private void decrementContainerEditMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.editMode = (IFluidContainerManager.ContainerEditMode)this.editMode.getPrevious();
        this.markDirty(false);
    }
}

