/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.energy.EnergyCubeEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.upgrade.EnergyCubeUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;

public class TileEntityEnergyCube
extends TileEntityConfigurableMachine {
    private EnergyCubeTier tier;
    private float prevScale;
    private EnergyCubeEnergyContainer energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChargeItem"})
    private EnergyInventorySlot chargeSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getDischargeItem"})
    private EnergyInventorySlot dischargeSlot;

    public TileEntityEnergyCube(IBlockProvider blockProvider) {
        super(blockProvider);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ENERGY, TransmissionType.ITEM);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, this.chargeSlot, this.dischargeSlot, RelativeSide.FRONT, true).setCanEject(false);
        this.configComponent.setupIOConfig(TransmissionType.ENERGY, this.energyContainer, RelativeSide.FRONT).setEjecting(true);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this, () -> this.tier.getOutput());
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ENERGY).setCanEject(type -> MekanismUtils.canFunction(this));
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.tier = Attribute.getTier(this.getBlockType(), EnergyCubeTier.class);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = EnergyCubeEnergyContainer.create(this.tier, (IContentsListener)this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.dischargeSlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityEnergyCube)this).func_145831_w(), this, 17, 35);
        builder.addSlot(this.dischargeSlot);
        this.chargeSlot = EnergyInventorySlot.drain(this.energyContainer, this, 143, 35);
        builder.addSlot(this.chargeSlot);
        this.dischargeSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.chargeSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    public EnergyCubeTier getTier() {
        return this.tier;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.chargeSlot.drainContainer();
        this.dischargeSlot.fillContainerOrConvert();
        float newScale = MekanismUtils.getScale(this.prevScale, this.energyContainer);
        if (newScale != this.prevScale) {
            this.prevScale = newScale;
            this.sendUpdatePacket();
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.energyContainer.getEnergy(), this.energyContainer.getMaxEnergy());
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof EnergyCubeUpgradeData) {
            EnergyCubeUpgradeData data = (EnergyCubeUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.chargeSlot.setStack(data.chargeSlot.getStack());
            this.dischargeSlot.deserializeNBT(data.dischargeSlot.serializeNBT());
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    public EnergyCubeEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @Nonnull
    public EnergyCubeUpgradeData getUpgradeData() {
        return new EnergyCubeUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.chargeSlot, this.dischargeSlot, this.getComponents());
    }

    public float getEnergyScale() {
        return this.prevScale;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74776_a("scale", this.prevScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
    }
}

