/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RotaryRecipeSerializer<RECIPE extends RotaryRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public RotaryRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        FluidStackIngredient fluidInputIngredient = null;
        GasStackIngredient gasInputIngredient = null;
        GasStack gasOutput = null;
        FluidStack fluidOutput = null;
        boolean hasFluidToGas = false;
        boolean hasGasToFluid = false;
        if (json.has("fluidInput") || json.has("gasOutput")) {
            JsonArray fluidInput = JSONUtils.func_151202_d((JsonObject)json, (String)"fluidInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"fluidInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"fluidInput");
            fluidInputIngredient = FluidStackIngredient.deserialize((JsonElement)fluidInput);
            gasOutput = SerializerHelper.getGasStack(json, "gasOutput");
            hasFluidToGas = true;
            if (gasOutput.isEmpty()) {
                throw new JsonSyntaxException("Rotary recipe gas output cannot be empty if it is defined.");
            }
        }
        if (json.has("gasInput") || json.has("fluidOutput")) {
            JsonArray gasInput = JSONUtils.func_151202_d((JsonObject)json, (String)"gasInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"gasInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"gasInput");
            gasInputIngredient = GasStackIngredient.deserialize((JsonElement)gasInput);
            fluidOutput = SerializerHelper.getFluidStack(json, "fluidOutput");
            hasGasToFluid = true;
            if (fluidOutput.isEmpty()) {
                throw new JsonSyntaxException("Rotary recipe fluid output cannot be empty if it is defined.");
            }
        }
        if (hasFluidToGas && hasGasToFluid) {
            return this.factory.create(recipeId, fluidInputIngredient, gasInputIngredient, gasOutput, fluidOutput);
        }
        if (hasFluidToGas) {
            return this.factory.create(recipeId, fluidInputIngredient, gasOutput);
        }
        if (hasGasToFluid) {
            return this.factory.create(recipeId, gasInputIngredient, fluidOutput);
        }
        throw new JsonSyntaxException("Rotary recipes require at least a gas to fluid or fluid to gas conversion.");
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            boolean hasGasToFluid;
            FluidStackIngredient fluidInputIngredient = null;
            GasStackIngredient gasInputIngredient = null;
            GasStack gasOutput = null;
            FluidStack fluidOutput = null;
            boolean hasFluidToGas = buffer.readBoolean();
            if (hasFluidToGas) {
                fluidInputIngredient = FluidStackIngredient.read(buffer);
                gasOutput = GasStack.readFromPacket(buffer);
            }
            if (hasGasToFluid = buffer.readBoolean()) {
                gasInputIngredient = GasStackIngredient.read(buffer);
                fluidOutput = FluidStack.readFromPacket((PacketBuffer)buffer);
            }
            if (hasFluidToGas && hasGasToFluid) {
                return this.factory.create(recipeId, fluidInputIngredient, gasInputIngredient, gasOutput, fluidOutput);
            }
            if (hasFluidToGas) {
                return this.factory.create(recipeId, fluidInputIngredient, gasOutput);
            }
            if (hasGasToFluid) {
                return this.factory.create(recipeId, gasInputIngredient, fluidOutput);
            }
            Mekanism.logger.error("Error reading rotary recipe from packet. A recipe got sent with no conversion in either direction.");
            return null;
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading rotary recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        if (((RotaryRecipe)recipe).hasFluidToGas() || ((RotaryRecipe)recipe).hasGasToFluid()) {
            try {
                ((RotaryRecipe)recipe).write(buffer);
            }
            catch (Exception e) {
                Mekanism.logger.error("Error writing rotary recipe to packet.", (Throwable)e);
                throw e;
            }
        } else {
            Mekanism.logger.error("Error writing rotary recipe to packet. {} has no conversion in either direction, so was not sent.", recipe);
        }
    }

    public static interface IFactory<RECIPE extends RotaryRecipe> {
        public RECIPE create(ResourceLocation var1, FluidStackIngredient var2, GasStack var3);

        public RECIPE create(ResourceLocation var1, GasStackIngredient var2, FluidStack var3);

        public RECIPE create(ResourceLocation var1, FluidStackIngredient var2, GasStackIngredient var3, GasStack var4, FluidStack var5);
    }
}

