/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.common.lib.HashedFluid;
import mekanism.common.recipe.lookup.cache.type.NBTSensitiveInputCache;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidInputCache<RECIPE extends MekanismRecipe>
extends NBTSensitiveInputCache<Fluid, HashedFluid, FluidStack, FluidStackIngredient, RECIPE> {
    @Override
    public boolean mapInputs(RECIPE recipe, FluidStackIngredient inputIngredient) {
        if (inputIngredient instanceof FluidStackIngredient.Single) {
            HashedFluid input = HashedFluid.create(((FluidStackIngredient.Single)inputIngredient).getInputRaw());
            this.addNbtInputCache(input, recipe);
        } else if (inputIngredient instanceof FluidStackIngredient.Tagged) {
            for (Fluid input : ((FluidStackIngredient.Tagged)inputIngredient).getRawInput()) {
                this.addInputCache(input, recipe);
            }
        } else {
            if (inputIngredient instanceof FluidStackIngredient.Multi) {
                return ((FluidStackIngredient.Multi)inputIngredient).forEachIngredient(ingredient -> this.mapInputs(recipe, (FluidStackIngredient)ingredient));
            }
            return true;
        }
        return false;
    }

    @Override
    protected Fluid createKey(FluidStack stack) {
        return stack.getFluid();
    }

    @Override
    protected HashedFluid createNbtKey(FluidStack stack) {
        return HashedFluid.raw(stack);
    }

    @Override
    public boolean isEmpty(FluidStack input) {
        return input.isEmpty();
    }
}

