/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.function.BiFunction;
import java.util.function.Function;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketGuiButtonPress
implements IMekanismPacket {
    private final Type type;
    private ClickedItemButton itemButton;
    private ClickedTileButton tileButton;
    private ClickedEntityButton entityButton;
    private Hand hand;
    private int entityID;
    private int extra;
    private BlockPos tilePosition;

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, TileEntity tile) {
        this(buttonClicked, tile.func_174877_v());
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, TileEntity tile, int extra) {
        this(buttonClicked, tile.func_174877_v(), extra);
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketGuiButtonPress(ClickedItemButton buttonClicked, Hand hand) {
        this.type = Type.ITEM;
        this.itemButton = buttonClicked;
        this.hand = hand;
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.type = Type.TILE;
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public PacketGuiButtonPress(ClickedEntityButton buttonClicked, Entity entity) {
        this(buttonClicked, entity.func_145782_y());
    }

    public PacketGuiButtonPress(ClickedEntityButton buttonClicked, int entityID) {
        this.type = Type.ENTITY;
        this.entityButton = buttonClicked;
        this.entityID = entityID;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        INamedContainerProvider provider;
        ItemStack stack;
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        if (this.type == Type.ENTITY) {
            INamedContainerProvider provider2;
            Entity entity = player.field_70170_p.func_73045_a(this.entityID);
            if (entity != null && (provider2 = this.entityButton.getProvider(entity)) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider2, buf -> buf.func_150787_b(this.entityID));
            }
        } else if (this.type == Type.TILE) {
            INamedContainerProvider provider3;
            TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, this.tilePosition);
            if (tile != null && (provider3 = this.tileButton.getProvider(tile, this.extra)) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider3, buf -> {
                    buf.func_179255_a(this.tilePosition);
                    buf.func_150787_b(this.extra);
                });
            }
        } else if (this.type == Type.ITEM && (stack = player.func_184586_b(this.hand)).func_77973_b() instanceof IGuiItem && (provider = this.itemButton.getProvider(stack, this.hand)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider, buf -> {
                buf.func_179249_a((Enum)this.hand);
                buf.func_150788_a(stack);
            });
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
        if (this.type == Type.ENTITY) {
            buffer.func_179249_a((Enum)this.entityButton);
            buffer.func_150787_b(this.entityID);
        } else if (this.type == Type.TILE) {
            buffer.func_179249_a((Enum)this.tileButton);
            buffer.func_179255_a(this.tilePosition);
            buffer.func_150787_b(this.extra);
        } else if (this.type == Type.ITEM) {
            buffer.func_179249_a((Enum)this.itemButton);
            buffer.func_179249_a((Enum)this.hand);
        }
    }

    public static PacketGuiButtonPress decode(PacketBuffer buffer) {
        Type type = (Type)buffer.func_179257_a(Type.class);
        switch (type) {
            case ENTITY: {
                return new PacketGuiButtonPress((ClickedEntityButton)buffer.func_179257_a(ClickedEntityButton.class), buffer.func_150792_a());
            }
            case TILE: {
                return new PacketGuiButtonPress((ClickedTileButton)buffer.func_179257_a(ClickedTileButton.class), buffer.func_179259_c(), buffer.func_150792_a());
            }
            case ITEM: {
                return new PacketGuiButtonPress((ClickedItemButton)buffer.func_179257_a(ClickedItemButton.class), (Hand)buffer.func_179257_a(Hand.class));
            }
        }
        return null;
    }

    public static enum Type {
        TILE,
        ITEM,
        ENTITY;

    }

    public static enum ClickedEntityButton {
        ROBIT_CRAFTING(entity -> MekanismContainerTypes.CRAFTING_ROBIT.getProvider(MekanismLang.ROBIT_CRAFTING, entity)),
        ROBIT_INVENTORY(entity -> MekanismContainerTypes.INVENTORY_ROBIT.getProvider(MekanismLang.ROBIT_INVENTORY, entity)),
        ROBIT_MAIN(entity -> MekanismContainerTypes.MAIN_ROBIT.getProvider(MekanismLang.ROBIT, entity)),
        ROBIT_REPAIR(entity -> MekanismContainerTypes.REPAIR_ROBIT.getProvider(MekanismLang.ROBIT_REPAIR, entity)),
        ROBIT_SMELTING(entity -> MekanismContainerTypes.SMELTING_ROBIT.getProvider(MekanismLang.ROBIT_SMELTING, entity));

        private final Function<Entity, INamedContainerProvider> providerFromEntity;

        private ClickedEntityButton(Function<Entity, INamedContainerProvider> providerFromEntity) {
            this.providerFromEntity = providerFromEntity;
        }

        public INamedContainerProvider getProvider(Entity entity) {
            return this.providerFromEntity.apply(entity);
        }
    }

    public static enum ClickedTileButton {
        BACK_BUTTON((tile, extra) -> {
            Block block = tile.getBlockType();
            if (Attribute.has(block, AttributeGui.class)) {
                return Attribute.get(block, AttributeGui.class).getProvider(tile);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((tile, extra) -> MekanismContainerTypes.QIO_FREQUENCY_SELECT_TILE.getProvider(MekanismLang.QIO_FREQUENCY_SELECT, tile)),
        DIGITAL_MINER_CONFIG((tile, extra) -> MekanismContainerTypes.DIGITAL_MINER_CONFIG.getProvider(MekanismLang.MINER_CONFIG, tile)),
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return MekanismContainerTypes.INDUCTION_MATRIX.getProvider(MekanismLang.MATRIX, tile);
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return MekanismContainerTypes.THERMOELECTRIC_BOILER.getProvider(MekanismLang.BOILER, tile);
            }
            return null;
        }),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return MekanismContainerTypes.MATRIX_STATS.getProvider(MekanismLang.MATRIX_STATS, tile);
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return MekanismContainerTypes.BOILER_STATS.getProvider(MekanismLang.BOILER_STATS, tile);
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile;

        private ClickedTileButton(BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public INamedContainerProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }

    public static enum ClickedItemButton {
        BACK_BUTTON((stack, hand) -> {
            if (stack.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)stack.func_77973_b()).getContainerType().getProvider(stack.func_200301_q(), (Hand)hand, (ItemStack)stack);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((stack, hand) -> MekanismContainerTypes.QIO_FREQUENCY_SELECT_ITEM.getProvider(MekanismLang.QIO_FREQUENCY_SELECT, (Hand)hand, (ItemStack)stack));

        private final BiFunction<ItemStack, Hand, INamedContainerProvider> providerFromItem;

        private ClickedItemButton(BiFunction<ItemStack, Hand, INamedContainerProvider> providerFromItem) {
            this.providerFromItem = providerFromItem;
        }

        public INamedContainerProvider getProvider(ItemStack stack, Hand hand) {
            return this.providerFromItem.apply(stack, hand);
        }
    }
}

