/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_client.PacketPlayerData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGearStateUpdate
implements IMekanismPacket {
    private final GearType gearType;
    private final boolean state;
    private final UUID uuid;

    public PacketGearStateUpdate(GearType gearType, UUID uuid, boolean state) {
        this.gearType = gearType;
        this.uuid = uuid;
        this.state = state;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (this.gearType == GearType.FLAMETHROWER) {
            Mekanism.playerState.setFlamethrowerState(this.uuid, this.state, false);
        } else if (this.gearType == GearType.JETPACK) {
            Mekanism.playerState.setJetpackState(this.uuid, this.state, false);
        } else if (this.gearType == GearType.SCUBA_MASK) {
            Mekanism.playerState.setScubaMaskState(this.uuid, this.state, false);
        } else if (this.gearType == GearType.GRAVITATIONAL_MODULATOR) {
            Mekanism.playerState.setGravitationalModulationState(this.uuid, this.state, false);
        }
        ServerPlayerEntity player = context.getSender();
        if (player != null) {
            Mekanism.packetHandler.sendToAllTracking(new PacketPlayerData(this.uuid), (Entity)player);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.gearType);
        buffer.func_179252_a(this.uuid);
        buffer.writeBoolean(this.state);
    }

    public static PacketGearStateUpdate decode(PacketBuffer buffer) {
        return new PacketGearStateUpdate((GearType)buffer.func_179257_a(GearType.class), buffer.func_179253_g(), buffer.readBoolean());
    }

    public static enum GearType {
        FLAMETHROWER,
        JETPACK,
        SCUBA_MASK,
        GRAVITATIONAL_MODULATOR;

    }
}

