/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDropperUse
implements IMekanismPacket {
    private final BlockPos pos;
    private final DropperAction action;
    private final TankType tankType;
    private final int tankId;

    public PacketDropperUse(BlockPos pos, DropperAction action, TankType tankType, int tankId) {
        this.pos = pos;
        this.action = action;
        this.tankType = tankType;
        this.tankId = tankId;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayerEntity player = context.getSender();
        if (player == null || this.tankId < 0) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, this.pos)) != null) {
            if (tile instanceof TileEntityMultiblock) {
                MultiblockData structure = ((TileEntityMultiblock)tile).getMultiblock();
                if (structure.isFormed()) {
                    this.handleTankType(structure, (PlayerEntity)player, stack, new Coord4D(structure.getBounds().getCenter(), player.field_70170_p));
                }
            } else {
                Block block;
                if (this.action == DropperAction.DUMP_TANK && !player.func_184812_l_() && Attribute.has(block = tile.getBlockType(), AttributeTier.class) && Attribute.get(block, AttributeTier.class).getTier().getBaseTier() == BaseTier.CREATIVE) {
                    return;
                }
                this.handleTankType(tile, (PlayerEntity)player, stack, tile.getTileCoord());
            }
        }
    }

    private <HANDLER extends IMekanismFluidHandler & IGasTracker & IPigmentTracker> void handleTankType(HANDLER handler, PlayerEntity player, ItemStack stack, Coord4D coord) {
        if (this.tankType == TankType.FLUID_TANK) {
            IExtendedFluidTank fluidTank = handler.getFluidTank(this.tankId, null);
            if (fluidTank != null) {
                this.handleFluidTank(player, stack, fluidTank);
            }
        } else if (this.tankType == TankType.GAS_TANK) {
            this.handleChemicalTanks(player, stack, ((IGasTracker)handler).getGasTanks(null), coord);
        } else if (this.tankType == TankType.INFUSION_TANK) {
            this.handleChemicalTanks(player, stack, ((IInfusionTracker)handler).getInfusionTanks(null), coord);
        } else if (this.tankType == TankType.PIGMENT_TANK) {
            this.handleChemicalTanks(player, stack, ((IPigmentTracker)handler).getPigmentTanks(null), coord);
        } else if (this.tankType == TankType.SLURRY_TANK) {
            this.handleChemicalTanks(player, stack, ((ISlurryTracker)handler).getSlurryTanks(null), coord);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> void handleChemicalTanks(PlayerEntity player, ItemStack stack, List<TANK> tanks, Coord4D coord) {
        if (this.tankId < tanks.size()) {
            this.handleChemicalTank(player, stack, (IChemicalTank)tanks.get(this.tankId), coord);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void handleChemicalTank(PlayerEntity player, ItemStack stack, IChemicalTank<CHEMICAL, STACK> tank, Coord4D coord) {
        if (this.action == DropperAction.DUMP_TANK) {
            if (!tank.isEmpty()) {
                if (tank instanceof IGasTank) {
                    MekanismAPI.getRadiationManager().dumpRadiation(coord, (GasStack)((IGasTank)tank).getStack());
                }
                tank.setEmpty();
            }
        } else {
            Object itemTank;
            IChemicalHandler handler;
            Optional cap = stack.getCapability(ChemicalUtil.getCapabilityForChemical(tank)).resolve();
            if (cap.isPresent() && (handler = (IChemicalHandler)cap.get()) instanceof IMekanismChemicalHandler && (itemTank = ((IMekanismChemicalHandler)handler).getChemicalTank(0, null)) != null) {
                if (this.action == DropperAction.FILL_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(tank, itemTank, player);
                } else if (this.action == DropperAction.DRAIN_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(itemTank, tank, player);
                }
            }
        }
    }

    private void handleFluidTank(PlayerEntity player, ItemStack stack, IExtendedFluidTank fluidTank) {
        IExtendedFluidTank itemFluidTank;
        IFluidHandlerItem fluidHandlerItem;
        if (this.action == DropperAction.DUMP_TANK) {
            fluidTank.setEmpty();
            return;
        }
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent() && (fluidHandlerItem = (IFluidHandlerItem)capability.get()) instanceof IMekanismFluidHandler && (itemFluidTank = ((IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null)) != null) {
            if (this.action == DropperAction.FILL_DROPPER) {
                PacketDropperUse.transferBetweenTanks(fluidTank, itemFluidTank, player);
            } else if (this.action == DropperAction.DRAIN_DROPPER) {
                PacketDropperUse.transferBetweenTanks(itemFluidTank, fluidTank, player);
            }
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void transferBetweenTanks(IChemicalTank<CHEMICAL, STACK> drainTank, IChemicalTank<CHEMICAL, STACK> fillTank, PlayerEntity player) {
        STACK extractedChemical;
        long amount;
        STACK chemicalInDrainTank;
        STACK simulatedRemainder;
        long remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0L && (remainder = ((ChemicalStack)(simulatedRemainder = fillTank.insert(chemicalInDrainTank = drainTank.getStack(), Action.SIMULATE, AutomationType.MANUAL))).getAmount()) < (amount = ((ChemicalStack)chemicalInDrainTank).getAmount()) && !((ChemicalStack)(extractedChemical = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL))).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)fillTank.insert(extractedChemical, Action.EXECUTE, AutomationType.MANUAL)).getAmount(), 0L);
            ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
        }
    }

    private static void transferBetweenTanks(IExtendedFluidTank drainTank, IExtendedFluidTank fillTank, PlayerEntity player) {
        FluidStack extractedFluid;
        int amount;
        FluidStack fluidInDrainTank;
        FluidStack simulatedRemainder;
        int remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0 && (remainder = (simulatedRemainder = fillTank.insert(fluidInDrainTank = drainTank.getFluid(), Action.SIMULATE, AutomationType.MANUAL)).getAmount()) < (amount = fluidInDrainTank.getAmount()) && !(extractedFluid = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(fillTank.insert(extractedFluid, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_179249_a((Enum)this.action);
        buffer.func_179249_a((Enum)this.tankType);
        buffer.func_150787_b(this.tankId);
    }

    public static PacketDropperUse decode(PacketBuffer buffer) {
        return new PacketDropperUse(buffer.func_179259_c(), (DropperAction)buffer.func_179257_a(DropperAction.class), (TankType)buffer.func_179257_a(TankType.class), buffer.func_150792_a());
    }

    public static enum TankType {
        GAS_TANK,
        FLUID_TANK,
        INFUSION_TANK,
        PIGMENT_TANK,
        SLURRY_TANK;

    }

    public static enum DropperAction {
        FILL_DROPPER,
        DRAIN_DROPPER,
        DUMP_TANK;

    }
}

