/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBlockSeismicVibrator
extends ItemBlockTooltip<BlockTile<?, ?>>
implements IItemSustainedInventory,
ISecurityItem {
    public ItemBlockSeismicVibrator(BlockTile<?, ?> block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1).setISTER(ISTERProvider::seismicVibrator));
    }

    @Override
    public void addDetails(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        StorageUtils.addStoredEnergy(stack, tooltip, true);
        tooltip.add((ITextComponent)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
    }

    public boolean func_195941_b(@Nonnull BlockItemUseContext context, @Nonnull BlockState state) {
        if (!WorldUtils.isValidReplaceableBlock((IBlockReader)context.func_195991_k(), context.func_195995_a().func_177984_a())) {
            return false;
        }
        return super.func_195941_b(context, state);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        AttributeEnergy attributeEnergy = Attribute.get(this.func_179223_d(), AttributeEnergy.class);
        ItemCapabilityWrapper.ItemCapability[] itemCapabilityArray = new ItemCapabilityWrapper.ItemCapability[1];
        itemCapabilityArray[0] = RateLimitEnergyHandler.create(attributeEnergy::getStorage, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue);
        return new ItemCapabilityWrapper(stack, itemCapabilityArray);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }
}

