/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IRadialModeItem;
import mekanism.common.item.interfaces.IRadialSelectorEnum;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemConfigurator
extends ItemEnergized
implements IRadialModeItem<ConfiguratorMode>,
IItemHUDProvider {
    public ItemConfigurator(Item.Properties properties) {
        super(MekanismConfig.gear.configuratorChargeRate, MekanismConfig.gear.configuratorMaxEnergy, properties.func_208103_a(Rarity.UNCOMMON));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)MekanismLang.STATE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return TextComponentUtil.build(EnumColor.AQUA, super.func_200295_i(stack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (world.field_72995_K || player == null) return ActionResultType.PASS;
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        ItemStack stack = context.func_195996_i();
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, pos);
        ConfiguratorMode mode = this.getMode(stack);
        if (mode.isConfigurating()) {
            TransmissionType transmissionType = Objects.requireNonNull(mode.getTransmission(), "Configurating state requires transmission type");
            if (tile instanceof ISideConfiguration && ((ISideConfiguration)tile).getConfig().supports(transmissionType)) {
                ISideConfiguration config = (ISideConfiguration)tile;
                ConfigInfo info = config.getConfig().getConfig(transmissionType);
                if (info == null) return ActionResultType.SUCCESS;
                RelativeSide relativeSide = RelativeSide.fromDirections(config.getDirection(), side);
                DataType dataType = info.getDataType(relativeSide);
                if (!player.func_225608_bj_()) {
                    player.func_145747_a(MekanismUtils.logFormat(MekanismLang.CONFIGURATOR_VIEW_MODE.translate(transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName())), Util.field_240973_b_);
                    return ActionResultType.SUCCESS;
                } else if (SecurityUtils.canAccess(player, tile)) {
                    if (!player.func_184812_l_()) {
                        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                        FloatingLong energyPerConfigure = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerConfigure.get();
                        if (energyContainer == null || energyContainer.extract(energyPerConfigure, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerConfigure)) {
                            return ActionResultType.FAIL;
                        }
                        energyContainer.extract(energyPerConfigure, Action.EXECUTE, AutomationType.MANUAL);
                    }
                    DataType old = dataType;
                    dataType = info.incrementDataType(relativeSide);
                    if (dataType == old) return ActionResultType.SUCCESS;
                    player.func_145747_a(MekanismUtils.logFormat(MekanismLang.CONFIGURATOR_TOGGLE_MODE.translate(transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName())), Util.field_240973_b_);
                    config.getConfig().sideChanged(transmissionType, relativeSide);
                    return ActionResultType.SUCCESS;
                } else {
                    SecurityUtils.displayNoAccess(player);
                }
                return ActionResultType.SUCCESS;
            }
            if (SecurityUtils.canAccess(player, tile)) {
                Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE_CAPABILITY, side).resolve();
                if (!capability.isPresent()) return ActionResultType.PASS;
                IConfigurable config = (IConfigurable)capability.get();
                if (!player.func_225608_bj_()) return config.onRightClick(player, side);
                return config.onSneakRightClick(player, side);
            }
            SecurityUtils.displayNoAccess(player);
            return ActionResultType.SUCCESS;
        }
        if (mode == ConfiguratorMode.EMPTY) {
            IMekanismInventory inv;
            if (!(tile instanceof IMekanismInventory) || !(inv = (IMekanismInventory)tile).hasInventory()) return ActionResultType.PASS;
            if (SecurityUtils.canAccess(player, tile)) {
                IEnergyContainer energyContainer;
                boolean creative = player.func_184812_l_();
                IEnergyContainer iEnergyContainer = energyContainer = creative ? null : StorageUtils.getEnergyContainer(stack, 0);
                if (!creative && energyContainer == null) {
                    return ActionResultType.FAIL;
                }
                FloatingLong energyPerItemDump = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerItem.get();
                for (IInventorySlot inventorySlot : inv.getInventorySlots(null)) {
                    if (inventorySlot.isEmpty()) continue;
                    if (!creative) {
                        if (energyContainer.extract(energyPerItemDump, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerItemDump)) return ActionResultType.SUCCESS;
                        energyContainer.extract(energyPerItemDump, Action.EXECUTE, AutomationType.MANUAL);
                    }
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inventorySlot.getStack().func_77946_l());
                    inventorySlot.setEmpty();
                }
                return ActionResultType.SUCCESS;
            }
            SecurityUtils.displayNoAccess(player);
            return ActionResultType.FAIL;
        }
        if (mode == ConfiguratorMode.ROTATE) {
            if (!(tile instanceof TileEntityMekanism)) return ActionResultType.SUCCESS;
            if (SecurityUtils.canAccess(player, tile)) {
                TileEntityMekanism tileMekanism = (TileEntityMekanism)tile;
                if (!Attribute.get(tileMekanism.getBlockType(), AttributeStateFacing.class).canRotate()) return ActionResultType.SUCCESS;
                if (!player.func_225608_bj_()) {
                    tileMekanism.setFacing(side);
                    return ActionResultType.SUCCESS;
                } else {
                    if (!player.func_225608_bj_()) return ActionResultType.SUCCESS;
                    tileMekanism.setFacing(side.func_176734_d());
                }
                return ActionResultType.SUCCESS;
            } else {
                SecurityUtils.displayNoAccess(player);
            }
            return ActionResultType.SUCCESS;
        }
        if (mode != ConfiguratorMode.WRENCH) return ActionResultType.PASS;
        return ActionResultType.PASS;
    }

    public EnumColor getColor(ConfiguratorMode mode) {
        return mode.getColor();
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return this.getMode(stack) == ConfiguratorMode.WRENCH;
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list, PlayerEntity player, ItemStack stack, EquipmentSlotType slotType) {
        list.add((ITextComponent)MekanismLang.MODE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        ConfiguratorMode newMode;
        ConfiguratorMode mode = this.getMode(stack);
        if (mode != (newMode = (ConfiguratorMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            if (displayChangeMessage) {
                player.func_145747_a(MekanismUtils.logFormat(MekanismLang.CONFIGURE_STATE.translate(newMode)), Util.field_240973_b_);
            }
        }
    }

    @Override
    @Nonnull
    public ITextComponent getScrollTextComponent(@Nonnull ItemStack stack) {
        return this.getMode(stack).getTextComponent();
    }

    @Override
    public void setMode(ItemStack stack, PlayerEntity player, ConfiguratorMode mode) {
        ItemDataUtils.setInt(stack, "state", mode.ordinal());
    }

    @Override
    public ConfiguratorMode getMode(ItemStack stack) {
        return ConfiguratorMode.byIndexStatic(ItemDataUtils.getInt(stack, "state"));
    }

    @Override
    public Class<ConfiguratorMode> getModeClass() {
        return ConfiguratorMode.class;
    }

    @Override
    public ConfiguratorMode getModeByIndex(int ordinal) {
        return ConfiguratorMode.byIndexStatic(ordinal);
    }

    @FieldsAreNonnullByDefault
    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static enum ConfiguratorMode implements IRadialSelectorEnum<ConfiguratorMode>,
    IHasTextComponent
    {
        CONFIGURATE_ITEMS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ITEM, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_FLUIDS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.FLUID, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_GASES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.GAS, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_INFUSE_TYPES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.INFUSION, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_PIGMENTS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.PIGMENT, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_SLURRIES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.SLURRY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_ENERGY(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ENERGY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_HEAT(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.HEAT, EnumColor.BRIGHT_GREEN, true, null),
        EMPTY(MekanismLang.CONFIGURATOR_EMPTY, null, EnumColor.DARK_RED, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "empty.png")),
        ROTATE(MekanismLang.CONFIGURATOR_ROTATE, null, EnumColor.YELLOW, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "rotate.png")),
        WRENCH(MekanismLang.CONFIGURATOR_WRENCH, null, EnumColor.PINK, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "wrench.png"));

        public static final ConfiguratorMode[] MODES;
        private final ILangEntry langEntry;
        @Nullable
        private final TransmissionType transmissionType;
        private final EnumColor color;
        private final boolean configurating;
        private final ResourceLocation icon;

        private ConfiguratorMode(ILangEntry langEntry, TransmissionType transmissionType, @Nullable EnumColor color, boolean configurating, ResourceLocation icon) {
            this.langEntry = langEntry;
            this.transmissionType = transmissionType;
            this.color = color;
            this.configurating = configurating;
            this.icon = transmissionType != null ? MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, transmissionType.getTransmission() + ".png") : icon;
        }

        @Override
        public ITextComponent getTextComponent() {
            if (this.transmissionType != null) {
                return this.langEntry.translateColored(this.color, this.transmissionType);
            }
            return this.langEntry.translateColored(this.color, new Object[0]);
        }

        @Override
        public EnumColor getColor() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        @Nullable
        public TransmissionType getTransmission() {
            switch (this) {
                case CONFIGURATE_ITEMS: {
                    return TransmissionType.ITEM;
                }
                case CONFIGURATE_FLUIDS: {
                    return TransmissionType.FLUID;
                }
                case CONFIGURATE_GASES: {
                    return TransmissionType.GAS;
                }
                case CONFIGURATE_INFUSE_TYPES: {
                    return TransmissionType.INFUSION;
                }
                case CONFIGURATE_PIGMENTS: {
                    return TransmissionType.PIGMENT;
                }
                case CONFIGURATE_SLURRIES: {
                    return TransmissionType.SLURRY;
                }
                case CONFIGURATE_ENERGY: {
                    return TransmissionType.ENERGY;
                }
                case CONFIGURATE_HEAT: {
                    return TransmissionType.HEAT;
                }
            }
            return null;
        }

        @Override
        @Nonnull
        public ConfiguratorMode byIndex(int index) {
            return ConfiguratorMode.byIndexStatic(index);
        }

        public static ConfiguratorMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public ITextComponent getShortText() {
            return this.configurating && this.transmissionType != null ? this.transmissionType.getLangEntry().translateColored(this.color, new Object[0]) : this.getTextComponent();
        }

        @Override
        public ResourceLocation getIcon() {
            return this.icon;
        }

        static {
            MODES = ConfiguratorMode.values();
        }
    }
}

