/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import java.util.List;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.SawmillIRecipe;
import mekanism.common.util.text.TextUtils;
import net.minecraft.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.Sawing")
public class SawmillRecipeManager
extends MekanismRecipeManager<SawmillRecipe> {
    public static final SawmillRecipeManager INSTANCE = new SawmillRecipeManager();

    private SawmillRecipeManager() {
        super(MekanismRecipeType.SAWING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, MCWeightedItemStack output) {
        this.addRecipe(name, input, output.getItemStack(), output.getWeight());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack output, double chance) {
        if (chance < 1.0) {
            this.addRecipe(name, input, ItemStack.field_190927_a, this.getAndValidateNotEmpty(output), this.getAndValidateSecondaryChance(chance));
        } else if (chance == 1.0) {
            this.addRecipe(name, input, this.getAndValidateNotEmpty(output), ItemStack.field_190927_a, 0.0);
        } else if (chance < 2.0) {
            ItemStack stack = this.getAndValidateNotEmpty(output);
            this.addRecipe(name, input, stack, stack.func_77946_l(), this.getAndValidateSecondaryChance(chance - 1.0));
        } else {
            throw new IllegalArgumentException("This sawing recipe should just have the amount increased or explicitly use the two output method.");
        }
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack mainOutput, MCWeightedItemStack secondaryOutput) {
        this.addRecipe(name, input, mainOutput, secondaryOutput.getItemStack(), secondaryOutput.getWeight());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack mainOutput, IItemStack secondaryOutput, double secondaryChance) {
        this.addRecipe(name, input, this.getAndValidateNotEmpty(mainOutput), this.getAndValidateNotEmpty(secondaryOutput), this.getAndValidateSecondaryChance(secondaryChance));
    }

    private void addRecipe(String name, ItemStackIngredient input, ItemStack mainOutput, ItemStack secondaryOutput, double secondaryChance) {
        this.addRecipe(new SawmillIRecipe(this.getAndValidateName(name), input, mainOutput, secondaryOutput, secondaryChance));
    }

    private double getAndValidateSecondaryChance(double secondaryChance) {
        if (secondaryChance <= 0.0 || secondaryChance > 1.0) {
            throw new IllegalArgumentException("This sawing recipe requires a secondary output chance greater than zero and at most one.");
        }
        return secondaryChance;
    }

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(SawmillRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                SawmillRecipe recipe = (SawmillRecipe)this.getRecipe();
                StringBuilder builder = new StringBuilder();
                List<ItemStack> mainOutputs = recipe.getMainOutputDefinition();
                if (!mainOutputs.isEmpty()) {
                    builder.append("main: ").append(CrTUtils.describeOutputs(mainOutputs, ItemStackHelper::getCommandString));
                }
                if (recipe.getSecondaryChance() > 0.0) {
                    if (!mainOutputs.isEmpty()) {
                        builder.append("; ");
                    }
                    if (recipe.getSecondaryChance() == 1.0) {
                        builder.append("secondary: ");
                    } else {
                        builder.append("secondary with chance ").append(TextUtils.getPercent(recipe.getSecondaryChance())).append(": ");
                    }
                    builder.append(CrTUtils.describeOutputs(recipe.getSecondaryOutputDefinition(), ItemStackHelper::getCommandString));
                }
                return builder.toString();
            }
        };
    }
}

