/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.PressurizedReactionIRecipe;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.Reaction")
public class PressurizedReactionRecipeManager
extends MekanismRecipeManager<PressurizedReactionRecipe> {
    public static final PressurizedReactionRecipeManager INSTANCE = new PressurizedReactionRecipeManager();

    private PressurizedReactionRecipeManager() {
        super(MekanismRecipeType.REACTION);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient inputSolid, FluidStackIngredient inputFluid, GasStackIngredient inputGas, int duration, IItemStack outputItem, @ZenCodeType.Optional(value="0 as mods.mekanism.api.FloatingLong") FloatingLong energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, this.getAndValidateNotEmpty(outputItem), GasStack.EMPTY, energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient inputSolid, FluidStackIngredient inputFluid, GasStackIngredient inputGas, int duration, ICrTChemicalStack.ICrTGasStack outputGas, @ZenCodeType.Optional(value="0 as mods.mekanism.api.FloatingLong") FloatingLong energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, ItemStack.field_190927_a, this.getAndValidateNotEmpty(outputGas), energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient inputSolid, FluidStackIngredient inputFluid, GasStackIngredient inputGas, int duration, IItemStack outputItem, ICrTChemicalStack.ICrTGasStack outputGas, @ZenCodeType.Optional(value="0 as mods.mekanism.api.FloatingLong") FloatingLong energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, this.getAndValidateNotEmpty(outputItem), this.getAndValidateNotEmpty(outputGas), energyRequired);
    }

    private void addRecipe(String name, ItemStackIngredient inputSolid, FluidStackIngredient inputFluid, GasStackIngredient inputGas, int duration, ItemStack outputItem, GasStack outputGas, FloatingLong energyRequired) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive! Duration: " + duration);
        }
        this.addRecipe(new PressurizedReactionIRecipe(this.getAndValidateName(name), inputSolid, inputFluid, inputGas, energyRequired.copyAsConst(), duration, outputItem, outputGas));
    }

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(PressurizedReactionRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                GasStack gasOutput;
                Pair<List<@NonNull ItemStack>, @NonNull GasStack> output = ((PressurizedReactionRecipe)this.getRecipe()).getOutputDefinition();
                StringBuilder builder = new StringBuilder();
                List itemOutputs = (List)output.getLeft();
                if (!itemOutputs.isEmpty()) {
                    builder.append("item: ").append(CrTUtils.describeOutputs(itemOutputs, ItemStackHelper::getCommandString));
                }
                if (!(gasOutput = (GasStack)output.getRight()).isEmpty()) {
                    if (!itemOutputs.isEmpty()) {
                        builder.append("; ");
                    }
                    builder.append("gas: ").append(new CrTChemicalStack.CrTGasStack(gasOutput));
                }
                return builder.toString();
            }
        };
    }
}

