/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.ElectrolysisIRecipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.Separating")
public class ElectrolysisRecipeManager
extends MekanismRecipeManager<ElectrolysisRecipe> {
    public static final ElectrolysisRecipeManager INSTANCE = new ElectrolysisRecipeManager();

    private ElectrolysisRecipeManager() {
        super(MekanismRecipeType.SEPARATING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput, @ZenCodeType.Optional(value="1 as mods.mekanism.api.FloatingLong") FloatingLong energyMultiplier) {
        if (energyMultiplier.smallerThan(FloatingLong.ONE)) {
            throw new IllegalArgumentException("Energy multiplier must be at least one! Multiplier: " + energyMultiplier);
        }
        this.addRecipe(new ElectrolysisIRecipe(this.getAndValidateName(name), input, energyMultiplier.copyAsConst(), this.getAndValidateNotEmpty(leftGasOutput), this.getAndValidateNotEmpty(rightGasOutput)));
    }

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ElectrolysisRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return new CrTChemicalStack.CrTGasStack(((ElectrolysisRecipe)this.getRecipe()).getLeftGasOutputRepresentation()) + " and " + new CrTChemicalStack.CrTGasStack(((ElectrolysisRecipe)this.getRecipe()).getRightGasOutputRepresentation());
            }
        };
    }
}

