/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content.builder;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.robit.RobitSkin;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.content.CrTContentUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.content.builder.RobitSkinBuilder")
public class CrTRobitSkinBuilder {
    private final ResourceLocation[] textures;
    @Nullable
    private Predicate<PlayerEntity> unlockedPredicate;
    @Nullable
    private ResourceLocation model;

    @ZenCodeType.Method
    public static CrTRobitSkinBuilder builder(ResourceLocation ... textures) {
        if (textures.length == 0) {
            throw new IllegalArgumentException("Robit skins require at least one texture!");
        }
        return new CrTRobitSkinBuilder(textures);
    }

    private CrTRobitSkinBuilder(ResourceLocation ... textures) {
        this.textures = textures;
    }

    @ZenCodeType.Method
    public CrTRobitSkinBuilder customModel(ResourceLocation model) {
        this.model = model;
        return this;
    }

    @ZenCodeType.Method
    public CrTRobitSkinBuilder unlockCheck(Predicate<PlayerEntity> unlockedPredicate) {
        this.unlockedPredicate = unlockedPredicate;
        return this;
    }

    @ZenCodeType.Method
    public void build(String name) {
        RobitSkin skin = this.unlockedPredicate == null && this.model == null ? new RobitSkin(this.textures) : new RobitSkin(this.textures){

            @Override
            @Nullable
            public ResourceLocation getCustomModel() {
                return CrTRobitSkinBuilder.this.model;
            }

            @Override
            public boolean isUnlocked(@Nonnull PlayerEntity player) {
                return CrTRobitSkinBuilder.this.unlockedPredicate == null ? super.isUnlocked(player) : CrTRobitSkinBuilder.this.unlockedPredicate.test(player);
            }
        };
        CrTContentUtils.queueRobitSkinForRegistration(CrTUtils.rl(name), skin);
    }
}

