/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.computercraft.CCArgumentWrapper;

public abstract class CCMethodCaller {
    private final BoundComputerMethod[] methods;
    private final String[] methodNames;

    protected CCMethodCaller(Map<String, BoundComputerMethod> boundMethods) {
        this.methods = new BoundComputerMethod[boundMethods.size()];
        this.methodNames = new String[this.methods.length];
        int i = 0;
        for (Map.Entry<String, BoundComputerMethod> entry : boundMethods.entrySet()) {
            this.methodNames[i] = entry.getKey();
            this.methods[i] = entry.getValue();
            ++i;
        }
    }

    protected abstract String getCallerType();

    @Nonnull
    public String[] getMethodNames() {
        return this.methodNames;
    }

    @Nonnull
    public MethodResult callMethod(@Nonnull ILuaContext context, int methodIndex, @Nonnull IArguments arguments) throws LuaException {
        if (methodIndex < 0 || methodIndex >= this.methods.length) {
            throw new LuaException(String.format(Locale.ROOT, "Method index '%d' is out of bounds. This %s only has '%d' methods.", methodIndex, this.getCallerType(), this.methods.length));
        }
        BoundComputerMethod method = this.methods[methodIndex];
        CCArgumentWrapper argumentWrapper = new CCArgumentWrapper(arguments);
        BoundComputerMethod.SelectedMethodInfo selectedImplementation = method.findMatchingImplementation(argumentWrapper);
        if (selectedImplementation.isThreadSafe()) {
            return method.run(argumentWrapper, selectedImplementation);
        }
        long task = context.issueMainThreadTask(() -> method.run(argumentWrapper, selectedImplementation).getResult());
        return new TaskCallback(task).pull;
    }

    private static class TaskCallback
    implements ILuaCallback {
        private final MethodResult pull = MethodResult.pullEvent((String)"task_complete", (ILuaCallback)this);
        private final long task;

        private TaskCallback(long task) {
            this.task = task;
        }

        @Nonnull
        public MethodResult resume(Object[] response) throws LuaException {
            if (response.length >= 3 && response[1] instanceof Number && response[2] instanceof Boolean) {
                if (((Number)response[1]).longValue() != this.task) {
                    return this.pull;
                }
                if (((Boolean)response[2]).booleanValue()) {
                    return MethodResult.of((Object[])Arrays.copyOfRange(response, 3, response.length));
                }
                if (response.length >= 4 && response[3] instanceof String) {
                    throw new LuaException((String)response[3]);
                }
                throw new LuaException("error");
            }
            return this.pull;
        }
    }
}

