/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFlame
extends ProjectileEntity
implements IEntityAdditionalSpawnData {
    public static final int LIFESPAN = 80;
    private static final int DAMAGE = 10;
    private ItemFlamethrower.FlamethrowerMode mode = ItemFlamethrower.FlamethrowerMode.COMBAT;

    public EntityFlame(EntityType<EntityFlame> type, World world) {
        super(type, world);
    }

    @Nullable
    public static EntityFlame create(PlayerEntity player) {
        EntityFlame flame = (EntityFlame)((EntityType)MekanismEntityTypes.FLAME.get()).func_200721_a(player.field_70170_p);
        if (flame == null) {
            return null;
        }
        Pos3D playerPos = new Pos3D(player.func_226277_ct_(), player.func_226280_cw_() - 0.1, player.func_226281_cx_());
        Pos3D flameVec = new Pos3D(1.0, 1.0, 1.0);
        Vector3d lookVec = player.func_70040_Z();
        flameVec = flameVec.multiply(lookVec).yRot(6.0f);
        Vector3d mergedVec = playerPos.func_178787_e(flameVec);
        flame.func_70107_b(mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c);
        flame.func_212361_a((Entity)player);
        ItemStack selected = player.field_71071_by.func_70448_g();
        flame.mode = ((ItemFlamethrower)selected.func_77973_b()).getMode(selected);
        flame.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 0.5f, 1.0f);
        BlockRayTraceResult blockRayTrace = player.field_70170_p.func_217299_a(new RayTraceContext((Vector3d)playerPos, mergedVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)flame));
        if (blockRayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            flame.func_70227_a((RayTraceResult)blockRayTrace);
        }
        return flame;
    }

    public void func_70030_z() {
        if (!this.func_70089_S()) {
            return;
        }
        ++this.field_70173_aa;
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        Vector3d motion = this.func_213322_ci();
        this.func_226288_n_(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c());
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.calculateVector();
        if (this.field_70173_aa > 80) {
            this.func_70106_y();
        }
    }

    private void calculateVector() {
        EntityRayTraceResult entityResult;
        Vector3d localVec = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vector3d motion = this.func_213322_ci();
        Vector3d motionVec = new Vector3d(this.func_226277_ct_() + motion.func_82615_a() * 2.0, this.func_226278_cu_() + motion.func_82617_b() * 2.0, this.func_226281_cx_() + motion.func_82616_c() * 2.0);
        BlockRayTraceResult blockRayTrace = this.field_70170_p.func_217299_a(new RayTraceContext(localVec, motionVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)this));
        localVec = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        motionVec = new Vector3d(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c());
        if (blockRayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            motionVec = blockRayTrace.func_216347_e();
        }
        this.func_70227_a((RayTraceResult)((entityResult = ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)localVec, (Vector3d)motionVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_72314_b(1.0, 1.0, 1.0), (Predicate)EntityPredicates.field_180132_d)) == null ? blockRayTrace : entityResult));
    }

    protected void func_213868_a(EntityRayTraceResult entityResult) {
        Entity entity = entityResult.func_216348_a();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Entity owner = this.func_234616_v_();
            if (player.field_71075_bZ.field_75102_a || owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a(player)) {
                return;
            }
        }
        if (!entity.func_230279_az_()) {
            if (entity instanceof ItemEntity && this.mode == ItemFlamethrower.FlamethrowerMode.HEAT) {
                if (entity.field_70173_aa > 100 && !this.smeltItem((ItemEntity)entity)) {
                    this.burn(entity);
                }
            } else {
                this.burn(entity);
            }
        }
        this.func_70106_y();
    }

    protected void func_230299_a_(@Nonnull BlockRayTraceResult blockRayTrace) {
        boolean hitFluid;
        super.func_230299_a_(blockRayTrace);
        BlockPos hitPos = blockRayTrace.func_216350_a();
        Direction hitSide = blockRayTrace.func_216354_b();
        BlockState hitState = this.field_70170_p.func_180495_p(hitPos);
        boolean bl = hitFluid = !hitState.func_204520_s().func_206888_e();
        if (!this.field_70170_p.field_72995_K && MekanismConfig.general.aestheticWorldDamage.get() && !hitFluid) {
            if (this.mode == ItemFlamethrower.FlamethrowerMode.HEAT) {
                Entity owner = this.func_234616_v_();
                if (owner instanceof PlayerEntity) {
                    this.smeltBlock((PlayerEntity)owner, hitState, hitPos, hitSide);
                }
            } else if (this.mode == ItemFlamethrower.FlamethrowerMode.INFERNO) {
                Entity owner = this.func_234616_v_();
                BlockPos sidePos = hitPos.func_177972_a(hitSide);
                if (CampfireBlock.func_241470_h_((BlockState)hitState)) {
                    this.tryPlace(owner, hitPos, hitSide, (BlockState)hitState.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
                } else if (AbstractFireBlock.func_241465_a_((World)this.field_70170_p, (BlockPos)sidePos, (Direction)hitSide)) {
                    this.tryPlace(owner, sidePos, hitSide, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)sidePos));
                } else if (hitState.isFlammable((IBlockReader)this.field_70170_p, hitPos, hitSide)) {
                    hitState.catchFire(this.field_70170_p, hitPos, hitSide, owner instanceof LivingEntity ? (LivingEntity)owner : null);
                    if (hitState.func_177230_c() instanceof TNTBlock) {
                        this.field_70170_p.func_217377_a(hitPos, false);
                    }
                }
            }
        }
        if (hitFluid) {
            this.spawnParticlesAt(this.func_233580_cy_());
            this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
        }
        this.func_70106_y();
    }

    private boolean tryPlace(@Nullable Entity shooter, BlockPos pos, Direction hitSide, BlockState newState) {
        BlockSnapshot blockSnapshot = BlockSnapshot.create((RegistryKey)this.field_70170_p.func_234923_W_(), (IWorld)this.field_70170_p, (BlockPos)pos);
        this.field_70170_p.func_175656_a(pos, newState);
        if (ForgeEventFactory.onBlockPlace((Entity)shooter, (BlockSnapshot)blockSnapshot, (Direction)hitSide)) {
            this.field_70170_p.restoringBlockSnapshots = true;
            blockSnapshot.restore(true, false);
            this.field_70170_p.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    private boolean smeltItem(ItemEntity item) {
        Optional recipe = this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{item.func_92059_d()}), this.field_70170_p);
        if (recipe.isPresent()) {
            ItemStack result = ((FurnaceRecipe)recipe.get()).func_77571_b();
            item.func_92058_a(StackUtils.size(result, item.func_92059_d().func_190916_E()));
            item.field_70173_aa = 0;
            this.spawnParticlesAt(item.func_233580_cy_());
            this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void smeltBlock(PlayerEntity shooter, BlockState hitState, BlockPos blockPos, Direction hitSide) {
        Optional recipe;
        if (hitState.isAir((IBlockReader)this.field_70170_p, blockPos)) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)hitState.func_177230_c());
        if (stack.func_190926_b()) {
            return;
        }
        try {
            recipe = this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_70170_p);
        }
        catch (Exception e) {
            return;
        }
        if (recipe.isPresent() && !this.field_70170_p.field_72995_K) {
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.field_70170_p, blockPos, hitState, shooter))) {
                return;
            }
            ItemStack result = ((FurnaceRecipe)recipe.get()).func_77571_b();
            if (!(result.func_77973_b() instanceof BlockItem) || !this.tryPlace((Entity)shooter, blockPos, hitSide, Block.func_149634_a((Item)result.func_77973_b()).func_176223_P())) {
                this.field_70170_p.func_217377_a(blockPos, false);
                ItemEntity item = new ItemEntity(this.field_70170_p, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, result.func_77946_l());
                item.func_213293_j(0.0, 0.0, 0.0);
                this.field_70170_p.func_217376_c((Entity)item);
            }
            this.field_70170_p.func_217379_c(2001, blockPos, Block.func_196246_j((BlockState)hitState));
            this.spawnParticlesAt((ServerWorld)this.field_70170_p, blockPos);
        }
    }

    private void burn(Entity entity) {
        if (!(entity instanceof ItemEntity) || MekanismConfig.gear.flamethrowerDestroyItems.get()) {
            entity.func_70015_d(20);
            entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), 10.0f);
        }
    }

    private void spawnParticlesAt(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + ((double)this.field_70146_Z.nextFloat() - 0.5), (double)pos.func_177956_o() + ((double)this.field_70146_Z.nextFloat() - 0.5), (double)pos.func_177952_p() + ((double)this.field_70146_Z.nextFloat() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    private void spawnParticlesAt(ServerWorld world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            world.func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + ((double)this.field_70146_Z.nextFloat() - 0.5), (double)pos.func_177956_o() + ((double)this.field_70146_Z.nextFloat() - 0.5), (double)pos.func_177952_p() + ((double)this.field_70146_Z.nextFloat() - 0.5), 3, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(@Nonnull CompoundNBT nbtTags) {
        super.func_70037_a(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "mode", ItemFlamethrower.FlamethrowerMode::byIndexStatic, mode -> {
            this.mode = mode;
        });
    }

    public void func_213281_b(@Nonnull CompoundNBT nbtTags) {
        super.func_213281_b(nbtTags);
        nbtTags.func_74768_a("mode", this.mode.ordinal());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer dataStream) {
        dataStream.func_179249_a((Enum)this.mode);
    }

    public void readSpawnData(PacketBuffer dataStream) {
        this.mode = (ItemFlamethrower.FlamethrowerMode)dataStream.func_179257_a(ItemFlamethrower.FlamethrowerMode.class);
    }
}

