/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class PathfinderCache {
    private static final Map<UUID, Map<PathData, CachedPath>> cachedPaths = new Object2ObjectOpenHashMap();

    private PathfinderCache() {
    }

    public static void onChanged(InventoryNetwork ... networks) {
        for (InventoryNetwork network : networks) {
            cachedPaths.remove(network.getUUID());
        }
    }

    public static void addCachedPath(LogisticalTransporterBase start, PathData data, List<BlockPos> positions, double cost) {
        cachedPaths.computeIfAbsent(((InventoryNetwork)start.getTransmitterNetwork()).getUUID(), uuid -> new Object2ObjectOpenHashMap()).put(data, new CachedPath(positions, cost));
    }

    public static CachedPath getCache(LogisticalTransporterBase start, BlockPos end, Set<Direction> sides) {
        CachedPath ret = null;
        UUID uuid = ((InventoryNetwork)start.getTransmitterNetwork()).getUUID();
        if (cachedPaths.containsKey(uuid)) {
            Map<PathData, CachedPath> pathMap = cachedPaths.get(uuid);
            for (Direction side : sides) {
                CachedPath test = pathMap.get(new PathData(start.getTilePos(), end, side));
                if (ret != null && (test == null || !(test.getCost() < ret.getCost()))) continue;
                ret = test;
            }
        }
        return ret;
    }

    public static void reset() {
        cachedPaths.clear();
    }

    public static class PathData {
        private final BlockPos startTransporter;
        private final BlockPos end;
        private final Direction endSide;
        private final int hash;

        public PathData(BlockPos s, BlockPos e, Direction es) {
            this.startTransporter = s;
            this.end = e;
            this.endSide = es;
            int code = 1;
            code = 31 * code + this.startTransporter.hashCode();
            code = 31 * code + this.end.hashCode();
            this.hash = code = 31 * code + this.endSide.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PathData) {
                PathData data = (PathData)obj;
                return data.startTransporter.equals((Object)this.startTransporter) && data.end.equals((Object)this.end) && data.endSide.equals((Object)this.endSide);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class CachedPath {
        private final List<BlockPos> path;
        private final double cost;

        public CachedPath(List<BlockPos> path, double cost) {
            this.path = path;
            this.cost = cost;
        }

        public List<BlockPos> getPath() {
            return this.path;
        }

        public double getCost() {
            return this.cost;
        }
    }
}

