/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import javax.annotation.Nonnull;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.miner.MinerFilter;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class MinerMaterialFilter
extends MinerFilter<MinerMaterialFilter>
implements IMaterialFilter<MinerMaterialFilter> {
    private ItemStack materialItem = ItemStack.field_190927_a;

    public MinerMaterialFilter(ItemStack item) {
        this.materialItem = item;
    }

    public MinerMaterialFilter() {
    }

    public MinerMaterialFilter(MinerMaterialFilter filter) {
        super(filter);
        this.materialItem = filter.materialItem.func_77946_l();
    }

    @Override
    public boolean canFilter(BlockState state) {
        return state.func_185904_a() == this.getMaterial();
    }

    @Override
    public boolean hasBlacklistedElement() {
        return !this.materialItem.func_190926_b() && this.materialItem.func_77973_b() instanceof BlockItem && TagCache.materialHasMinerBlacklisted(this.materialItem);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        this.materialItem.func_77955_b(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.materialItem = ItemStack.func_199557_a((CompoundNBT)nbtTags);
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.func_150788_a(this.materialItem);
    }

    @Override
    public void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.materialItem = dataStream.func_150791_c();
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.materialItem.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof MinerMaterialFilter && ((MinerMaterialFilter)filter).materialItem.func_77969_a(this.materialItem);
    }

    @Override
    public MinerMaterialFilter clone() {
        return new MinerMaterialFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_MATERIAL_FILTER;
    }

    @Override
    @Nonnull
    public ItemStack getMaterialItem() {
        return this.materialItem;
    }

    @Override
    public void setMaterialItem(@Nonnull ItemStack stack) {
        this.materialItem = stack;
    }
}

