/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.DamageSource;

@ParametersAreNonnullByDefault
public class ModuleInhalationPurificationUnit
implements ICustomModule<ModuleInhalationPurificationUnit> {
    private static final ICustomModule.ModuleDamageAbsorbInfo INHALATION_ABSORB_INFO = new ICustomModule.ModuleDamageAbsorbInfo(MekanismConfig.gear.mekaSuitMagicDamageRatio, MekanismConfig.gear.mekaSuitEnergyUsageMagicReduce);
    private IModuleConfigItem<Boolean> beneficialEffects;
    private IModuleConfigItem<Boolean> neutralEffects;
    private IModuleConfigItem<Boolean> harmfulEffects;

    @Override
    public void init(IModule<ModuleInhalationPurificationUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.beneficialEffects = configItemCreator.createConfigItem("beneficial_effects", MekanismLang.MODULE_PURIFICATION_BENEFICIAL, new ModuleBooleanData(false));
        this.neutralEffects = configItemCreator.createConfigItem("neutral_effects", MekanismLang.MODULE_PURIFICATION_NEUTRAL, new ModuleBooleanData());
        this.harmfulEffects = configItemCreator.createConfigItem("harmful_effects", MekanismLang.MODULE_PURIFICATION_HARMFUL, new ModuleBooleanData());
    }

    @Override
    public void tickClient(IModule<ModuleInhalationPurificationUnit> module, PlayerEntity player) {
        if (!player.func_175149_v()) {
            FloatingLong energy;
            FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
            boolean free = usage.isZero() || player.func_184812_l_();
            FloatingLong floatingLong = energy = free ? FloatingLong.ZERO : module.getContainerEnergy().copy();
            if (free || energy.greaterOrEqual(usage)) {
                List effects = player.func_70651_bq().stream().filter(effect -> this.canHandle(effect.func_188419_a().func_220303_e())).collect(Collectors.toList());
                for (EffectInstance effect2 : effects) {
                    if (free) {
                        this.speedupEffect(player, effect2);
                        continue;
                    }
                    energy = energy.minusEqual(usage);
                    this.speedupEffect(player, effect2);
                    if (!energy.smallerThan(usage)) continue;
                    break;
                }
            }
        }
    }

    @Override
    public void tickServer(IModule<ModuleInhalationPurificationUnit> module, PlayerEntity player) {
        IEnergyContainer energyContainer;
        FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
        boolean free = usage.isZero() || player.func_184812_l_();
        IEnergyContainer iEnergyContainer = energyContainer = free ? null : module.getEnergyContainer();
        if (free || energyContainer != null && energyContainer.getEnergy().greaterOrEqual(usage)) {
            List effects = player.func_70651_bq().stream().filter(effect -> this.canHandle(effect.func_188419_a().func_220303_e())).collect(Collectors.toList());
            for (EffectInstance effect2 : effects) {
                if (free) {
                    this.speedupEffect(player, effect2);
                    continue;
                }
                if (module.useEnergy((LivingEntity)player, energyContainer, usage, true).isZero()) break;
                this.speedupEffect(player, effect2);
                if (!energyContainer.getEnergy().smallerThan(usage)) continue;
                break;
            }
        }
    }

    @Override
    @Nullable
    public ICustomModule.ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<ModuleInhalationPurificationUnit> module, DamageSource damageSource) {
        return damageSource.func_82725_o() ? INHALATION_ABSORB_INFO : null;
    }

    private void speedupEffect(PlayerEntity player, EffectInstance effect) {
        for (int i = 0; i < 9; ++i) {
            MekanismUtils.speedUpEffectSafely((LivingEntity)player, effect);
        }
    }

    private boolean canHandle(EffectType effectType) {
        switch (effectType) {
            case BENEFICIAL: {
                return this.beneficialEffects.get();
            }
            case HARMFUL: {
                return this.harmfulEffects.get();
            }
            case NEUTRAL: {
                return this.neutralEffects.get();
            }
        }
        return false;
    }
}

