/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.multiblock.TileEntitySuperheatingElement;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;

public class BoilerValidator
extends CuboidStructureValidator<BoilerMultiblockData> {
    @Override
    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.func_177230_c();
        if (BlockType.is(block, MekanismBlockTypes.BOILER_CASING)) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is(block, MekanismBlockTypes.BOILER_VALVE)) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    @Override
    protected boolean validateInner(BlockState state, Long2ObjectMap<IChunk> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is(state.func_177230_c(), MekanismBlockTypes.PRESSURE_DISPERSER, MekanismBlockTypes.SUPERHEATING_ELEMENT);
    }

    @Override
    public FormationProtocol.FormationResult postcheck(BoilerMultiblockData structure, Set<BlockPos> innerNodes, Long2ObjectMap<IChunk> chunkMap) {
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet elements = new ObjectOpenHashSet();
        for (BlockPos pos : innerNodes) {
            TileEntity tile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, pos);
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(pos);
                continue;
            }
            if (!(tile instanceof TileEntitySuperheatingElement)) continue;
            structure.internalLocations.add(pos);
            elements.add(pos);
        }
        if (dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_NO_DISPERSER);
        }
        if (elements.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_SUPERHEATING);
        }
        BlockPos initDisperser = (BlockPos)dispersers.iterator().next();
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = 1; x < structure.length() - 1; ++x) {
            for (int z = 1; z < structure.width() - 1; ++z) {
                mutablePos.func_181079_c(structure.renderLocation.func_177958_n() + x, initDisperser.func_177956_o(), structure.renderLocation.func_177952_p() + z);
                TileEntityPressureDisperser tile = WorldUtils.getTileEntity(TileEntityPressureDisperser.class, (IWorld)this.world, chunkMap, (BlockPos)mutablePos);
                if (tile == null) {
                    return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_MISSING_DISPERSER, (BlockPos)mutablePos);
                }
                dispersers.remove(mutablePos);
            }
        }
        if (!dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_EXTRA_DISPERSER);
        }
        structure.superheatingElements = FormationProtocol.explore((BlockPos)elements.iterator().next(), coord -> coord.func_177956_o() < initDisperser.func_177956_o() && WorldUtils.getTileEntity(TileEntitySuperheatingElement.class, (IWorld)this.world, chunkMap, coord) != null);
        if (elements.size() > structure.superheatingElements) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_SUPERHEATING);
        }
        BlockPos initAir = null;
        BlockPos.Mutable mutableAir = new BlockPos.Mutable();
        int totalAir = 0;
        for (int x = structure.renderLocation.func_177958_n(); x < structure.renderLocation.func_177958_n() + structure.length(); ++x) {
            for (int y = structure.renderLocation.func_177956_o(); y < initDisperser.func_177956_o(); ++y) {
                for (int z = structure.renderLocation.func_177952_p(); z < structure.renderLocation.func_177952_p() + structure.width(); ++z) {
                    mutableAir.func_181079_c(x, y, z);
                    if (!this.isAirOrFrame(chunkMap, (BlockPos)mutableAir)) continue;
                    initAir = mutableAir.func_185334_h();
                    ++totalAir;
                }
            }
        }
        BlockPos renderLocation = structure.renderLocation;
        int volLength = structure.length();
        int volWidth = structure.width();
        structure.setWaterVolume(FormationProtocol.explore(initAir, coord -> coord.func_177956_o() >= renderLocation.func_177956_o() - 1 && coord.func_177956_o() < initDisperser.func_177956_o() && coord.func_177958_n() >= renderLocation.func_177958_n() && coord.func_177958_n() < renderLocation.func_177958_n() + volLength && coord.func_177952_p() >= renderLocation.func_177952_p() && coord.func_177952_p() < renderLocation.func_177952_p() + volWidth && this.isAirOrFrame(chunkMap, (BlockPos)coord)));
        if (totalAir > structure.getWaterVolume()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_AIR_POCKETS);
        }
        int steamHeight = structure.renderLocation.func_177956_o() + structure.height() - 2 - initDisperser.func_177956_o();
        structure.setSteamVolume(structure.width() * structure.length() * steamHeight);
        structure.upperRenderLocation = new BlockPos(structure.renderLocation.func_177958_n(), initDisperser.func_177956_o() + 1, structure.renderLocation.func_177952_p());
        return FormationProtocol.FormationResult.SUCCESS;
    }

    private boolean isAirOrFrame(Long2ObjectMap<IChunk> chunkMap, BlockPos airPos) {
        Optional<BlockState> stateOptional = WorldUtils.getBlockState((IWorld)this.world, chunkMap, airPos);
        return stateOptional.isPresent() && stateOptional.get().isAir((IBlockReader)this.world, airPos) || this.isFrameCompatible(WorldUtils.getTileEntity((IWorld)this.world, chunkMap, airPos));
    }
}

