/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.basic;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public class DefaultStorageHelper {
    private DefaultStorageHelper() {
    }

    public static class NullStorage<T>
    implements Capability.IStorage<T> {
        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            return new CompoundNBT();
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
        }
    }

    public static class DefaultStorage<T>
    implements Capability.IStorage<T> {
        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            if (instance instanceof INBTSerializable) {
                return ((INBTSerializable)instance).serializeNBT();
            }
            return new CompoundNBT();
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            Class<?> nbtClass;
            if (instance instanceof INBTSerializable && (nbtClass = ((INBTSerializable)instance).serializeNBT().getClass()).isInstance(nbt)) {
                ((INBTSerializable)instance).deserializeNBT((INBT)nbtClass.cast(nbt));
            }
        }
    }
}

