/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public abstract class PlayerSound
extends TickableSound {
    @Nonnull
    private final WeakReference<PlayerEntity> playerReference;
    private final int subtitleFrequency;
    private float lastX;
    private float lastY;
    private float lastZ;
    private float fadeUpStep = 0.1f;
    private float fadeDownStep = 0.1f;
    private int consecutiveTicks;

    public PlayerSound(@Nonnull PlayerEntity player, @Nonnull SoundEventRegistryObject<?> sound) {
        this(player, (SoundEvent)sound.get(), 60);
    }

    public PlayerSound(@Nonnull PlayerEntity player, @Nonnull SoundEvent sound, int subtitleFrequency) {
        super(sound, SoundCategory.PLAYERS);
        this.playerReference = new WeakReference<PlayerEntity>(player);
        this.subtitleFrequency = subtitleFrequency;
        this.lastX = (float)player.func_226277_ct_();
        this.lastY = (float)player.func_226278_cu_();
        this.lastZ = (float)player.func_226281_cx_();
        this.field_147659_g = true;
        this.field_147665_h = 0;
        this.field_147662_b = 0.1f;
    }

    @Nullable
    private PlayerEntity getPlayer() {
        return (PlayerEntity)this.playerReference.get();
    }

    protected void setFade(float fadeUpStep, float fadeDownStep) {
        this.fadeUpStep = fadeUpStep;
        this.fadeDownStep = fadeDownStep;
    }

    public double func_147649_g() {
        PlayerEntity player = this.getPlayer();
        if (player != null) {
            this.lastX = (float)player.func_226277_ct_();
        }
        return this.lastX;
    }

    public double func_147654_h() {
        PlayerEntity player = this.getPlayer();
        if (player != null) {
            this.lastY = (float)player.func_226278_cu_();
        }
        return this.lastY;
    }

    public double func_147651_i() {
        PlayerEntity player = this.getPlayer();
        if (player != null) {
            this.lastZ = (float)player.func_226281_cx_();
        }
        return this.lastZ;
    }

    public void func_73660_a() {
        PlayerEntity player = this.getPlayer();
        if (player == null || !player.func_70089_S()) {
            this.func_239509_o_();
            this.field_147662_b = 0.0f;
            this.consecutiveTicks = 0;
            return;
        }
        if (this.shouldPlaySound(player)) {
            if (this.field_147662_b < 1.0f) {
                this.field_147662_b = Math.min(1.0f, this.field_147662_b + this.fadeUpStep);
            }
            if (this.consecutiveTicks % this.subtitleFrequency == 0) {
                SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
                for (ISoundEventListener soundEventListener : soundHandler.field_147694_f.field_188777_o) {
                    SoundEventAccessor soundEventAccessor = this.func_184366_a(soundHandler);
                    if (soundEventAccessor == null) continue;
                    soundEventListener.func_184067_a((ISound)this, soundEventAccessor);
                }
                this.consecutiveTicks = 1;
            } else {
                ++this.consecutiveTicks;
            }
        } else if (this.field_147662_b > 0.0f) {
            this.consecutiveTicks = 0;
            this.field_147662_b = Math.max(0.0f, this.field_147662_b - this.fadeDownStep);
        }
    }

    public abstract boolean shouldPlaySound(@Nonnull PlayerEntity var1);

    public float func_147653_e() {
        return super.func_147653_e() * MekanismConfig.client.baseSoundVolume.get();
    }

    public boolean func_211503_n() {
        return true;
    }

    public boolean func_230510_t_() {
        PlayerEntity player = this.getPlayer();
        if (player == null) {
            return super.func_230510_t_();
        }
        return !player.func_174814_R();
    }

    public static enum SoundType {
        FLAMETHROWER,
        JETPACK,
        SCUBA_MASK,
        GRAVITATIONAL_MODULATOR;

    }
}

