/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import mekanism.common.lib.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.vector.Vector3d;

public class Vertex {
    private static final float LIGHT_PACK_FACTOR = 0.0073244423f;
    private Vector3d pos;
    private Vector3d normal;
    private Color color;
    private float texU;
    private float texV;
    private float lightU;
    private float lightV;

    public Vertex() {
    }

    public Vertex(Vector3d pos, Vector3d normal, Color color, float texU, float texV, float lightU, float lightV) {
        this.pos = pos;
        this.normal = normal;
        this.color = color;
        this.texU = texU;
        this.texV = texV;
        this.lightU = lightU;
        this.lightV = lightV;
    }

    public static Vertex create(Vector3d pos, Vector3d normal, Color color, TextureAtlasSprite sprite, float texU, float texV, float lightU, float lightV) {
        return new Vertex(pos, normal, color, sprite.func_94214_a((double)texU), sprite.func_94207_b((double)texV), lightU, lightV);
    }

    public static Vertex create(Vector3d pos, Vector3d normal, TextureAtlasSprite sprite, float u, float v) {
        return Vertex.create(pos, normal, Color.WHITE, sprite, u, v, 0.0f, 0.0f);
    }

    public Vector3d getPos() {
        return this.pos;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public Color getColor() {
        return this.color;
    }

    public float getTexU() {
        return this.texU;
    }

    public float getTexV() {
        return this.texV;
    }

    public float getLightU() {
        return this.lightU;
    }

    public float getLightV() {
        return this.lightV;
    }

    public Vertex color(Color color) {
        this.color = color;
        return this;
    }

    public Vertex pos(Vector3d pos) {
        this.pos = pos;
        return this;
    }

    public Vertex normal(Vector3d normal) {
        this.normal = normal;
        return this;
    }

    public Vertex texRaw(float u, float v) {
        this.texU = u;
        this.texV = v;
        return this;
    }

    public Vertex lightRaw(float u, float v) {
        this.lightU = u;
        this.lightV = v;
        return this;
    }

    public Vertex light(float u, float v) {
        return this.lightRaw(u * 0.0073244423f, v * 0.0073244423f);
    }

    public Vertex copy() {
        return new Vertex(this.pos, this.normal, this.color, this.texU, this.texV, this.lightU, this.lightV);
    }

    public float[][] pack(VertexFormat format) {
        float[][] ret = new float[format.func_227894_c_().size()][4];
        block6: for (int i = 0; i < format.func_227894_c_().size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)format.func_227894_c_().get(i);
            switch (element.func_177375_c()) {
                case POSITION: {
                    ret[i][0] = (float)this.pos.func_82615_a();
                    ret[i][1] = (float)this.pos.func_82617_b();
                    ret[i][2] = (float)this.pos.func_82616_c();
                    continue block6;
                }
                case NORMAL: {
                    ret[i][0] = (float)this.normal.func_82615_a();
                    ret[i][1] = (float)this.normal.func_82617_b();
                    ret[i][2] = (float)this.normal.func_82616_c();
                    continue block6;
                }
                case COLOR: {
                    ret[i][0] = this.color.rf();
                    ret[i][1] = this.color.gf();
                    ret[i][2] = this.color.bf();
                    ret[i][3] = this.color.af();
                    continue block6;
                }
                case UV: {
                    if (element.func_177369_e() == 0) {
                        ret[i][0] = this.texU;
                        ret[i][1] = this.texV;
                        continue block6;
                    }
                    if (element.func_177369_e() != 2) continue block6;
                    ret[i][0] = this.lightU;
                    ret[i][1] = this.lightV;
                    continue block6;
                }
            }
        }
        return ret;
    }
}

