/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import javax.annotation.Nonnull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class ChemicalRenderData<STACK extends ChemicalStack<?>>
extends RenderData {
    @Nonnull
    public final STACK chemicalType;

    protected ChemicalRenderData(@Nonnull STACK chemicalType) {
        this.chemicalType = chemicalType;
    }

    @Override
    public int getColorARGB(float scale) {
        return MekanismRenderer.getColorARGB(this.chemicalType, scale, this.isGaseous());
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return MekanismRenderer.getChemicalTexture(((ChemicalStack)this.chemicalType).getType());
    }

    @Override
    public boolean isGaseous() {
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + ((ChemicalStack)this.chemicalType).getTypeRegistryName().hashCode();
        return code;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return ((ChemicalStack)this.chemicalType).isTypeEqual(((ChemicalRenderData)o).chemicalType);
    }

    public static class SlurryRenderData
    extends ChemicalRenderData<SlurryStack> {
        public SlurryRenderData(@Nonnull SlurryStack chemicalType) {
            super(chemicalType);
        }
    }

    public static class PigmentRenderData
    extends ChemicalRenderData<PigmentStack> {
        public PigmentRenderData(@Nonnull PigmentStack chemicalType) {
            super(chemicalType);
        }
    }

    public static class InfusionRenderData
    extends ChemicalRenderData<InfusionStack> {
        public InfusionRenderData(@Nonnull InfusionStack chemicalType) {
            super(chemicalType);
        }
    }

    public static class GasRenderData
    extends ChemicalRenderData<GasStack> {
        public GasRenderData(@Nonnull GasStack chemicalType) {
            super(chemicalType);
        }

        @Override
        public boolean isGaseous() {
            return true;
        }
    }
}

