/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;

public class ModelIndustrialAlarm
extends MekanismJavaModel {
    private static final ResourceLocation TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "industrial_alarm.png");
    private static final ResourceLocation TEXTURE_ACTIVE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "industrial_alarm_active.png");
    private final RenderType RENDER_TYPE = MekanismRenderType.mekStandard(TEXTURE);
    private final RenderType RENDER_TYPE_ACTIVE = MekanismRenderType.mekStandard(TEXTURE_ACTIVE);
    private final ModelRenderer base;
    private final ModelRenderer bulb;
    private final ModelRenderer light_box;
    private final ModelRenderer aura;

    public ModelIndustrialAlarm() {
        super(RenderType::func_228634_a_);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.base = new ModelRenderer((Model)this, 0, 9);
        this.base.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 1.0f, 6.0f);
        this.base.func_78793_a(0.0f, 0.0f, 0.0f);
        this.base.func_78787_b(64, 64);
        this.setRotation(this.base, 0.0f, 0.0f, 0.0f);
        this.bulb = new ModelRenderer((Model)this, 16, 0);
        this.bulb.func_228300_a_(-1.0f, 1.0f, -1.0f, 2.0f, 3.0f, 2.0f);
        this.bulb.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bulb.func_78787_b(64, 64);
        this.setRotation(this.bulb, 0.0f, 0.0f, 0.0f);
        this.light_box = new ModelRenderer((Model)this, 0, 0);
        this.light_box.func_228300_a_(-2.0f, 1.0f, -2.0f, 4.0f, 4.0f, 4.0f);
        this.light_box.func_78793_a(0.0f, 0.0f, 0.0f);
        this.light_box.func_78787_b(64, 64);
        this.setRotation(this.light_box, 0.0f, 0.0f, 0.0f);
        this.aura = new ModelRenderer((Model)this, 0, 16);
        this.aura.func_228300_a_(-6.0f, 2.0f, -1.0f, 12.0f, 1.0f, 2.0f);
        this.aura.func_78793_a(0.0f, 0.0f, 0.0f);
        this.aura.func_78787_b(64, 64);
        this.setRotation(this.aura, 0.0f, 0.0f, 0.0f);
    }

    public void render(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, boolean active, float rotation, boolean renderBase, boolean hasEffect) {
        this.render(matrix, this.getVertexBuilder(renderer, active ? this.RENDER_TYPE_ACTIVE : this.RENDER_TYPE, hasEffect), light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f, active, rotation, renderBase);
    }

    public void func_225598_a_(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha) {
        this.render(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha, false, 0.0f, false);
    }

    private void render(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha, boolean active, float rotation, boolean renderBase) {
        if (renderBase) {
            this.base.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        }
        if (active) {
            this.setRotation(this.aura, 0.0f, (float)Math.toRadians(rotation), 0.0f);
            this.setRotation(this.bulb, 0.0f, (float)Math.toRadians(rotation), 0.0f);
        } else {
            this.setRotation(this.aura, 0.0f, 0.0f, 0.0f);
            this.setRotation(this.bulb, 0.0f, 0.0f, 0.0f);
        }
        float bulbAlpha = 0.3f + Math.abs(rotation * 2.0f % 360.0f - 180.0f) / 180.0f * 0.7f;
        this.bulb.func_228309_a_(matrix, vertexBuilder, active ? 0xF000F0 : light, overlayLight, red, green, blue, bulbAlpha);
        this.light_box.func_228309_a_(matrix, vertexBuilder, active ? 0xF000F0 : light, overlayLight, red, green, blue, alpha);
        if (!renderBase) {
            this.aura.func_228309_a_(matrix, vertexBuilder, 0xF000F0, overlayLight, red, green, blue, bulbAlpha);
        }
    }
}

