/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;

public class ChemicalDissolutionRecipeCategory
extends BaseRecipeCategory<ChemicalDissolutionRecipe> {
    private final GuiGauge<?> inputGauge = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 7, 4));
    private final GuiGauge<?> outputGauge = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.OUTPUT), this, 131, 13));
    private final GuiSlot inputSlot = this.addSlot(SlotType.INPUT, 28, 36);

    public ChemicalDissolutionRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, 3, 3, 170, 79);
        this.addSlot(SlotType.EXTRA, 8, 65).with(SlotOverlay.MINUS);
        this.addSlot(SlotType.OUTPUT, 152, 55).with(SlotOverlay.PLUS);
        this.addSlot(SlotType.POWER, 152, 14).with(SlotOverlay.POWER);
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 64, 40);
        this.addElement(new GuiHorizontalPowerBar((IGuiWrapper)this, FULL_BAR, 115, 75));
    }

    public Class<? extends ChemicalDissolutionRecipe> getRecipeClass() {
        return ChemicalDissolutionRecipe.class;
    }

    public void setIngredients(ChemicalDissolutionRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInput().getRepresentations()));
        List<@NonNull TYPE> gasInputs = recipe.getGasInput().getRepresentations();
        List scaledGases = gasInputs.stream().map(gas -> new GasStack((GasStack)gas, gas.getAmount() * 100L)).collect(Collectors.toList());
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(scaledGases));
        BoxedChemicalStack outputDefinition = recipe.getOutputDefinition();
        ChemicalType chemicalType = outputDefinition.getChemicalType();
        if (chemicalType == ChemicalType.GAS) {
            ingredients.setOutput(MekanismJEI.TYPE_GAS, (Object)((GasStack)outputDefinition.getChemicalStack()));
        } else if (chemicalType == ChemicalType.INFUSION) {
            ingredients.setOutput(MekanismJEI.TYPE_INFUSION, (Object)((InfusionStack)outputDefinition.getChemicalStack()));
        } else if (chemicalType == ChemicalType.PIGMENT) {
            ingredients.setOutput(MekanismJEI.TYPE_PIGMENT, (Object)((PigmentStack)outputDefinition.getChemicalStack()));
        } else if (chemicalType == ChemicalType.SLURRY) {
            ingredients.setOutput(MekanismJEI.TYPE_SLURRY, (Object)((SlurryStack)outputDefinition.getChemicalStack()));
        } else {
            throw new IllegalStateException("Unknown chemical type");
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChemicalDissolutionRecipe recipe, IIngredients ingredients) {
        this.initItem((IGuiIngredientGroup<ItemStack>)recipeLayout.getItemStacks(), 0, true, this.inputSlot, recipe.getItemInput().getRepresentations());
        List<@NonNull TYPE> gasInputs = recipe.getGasInput().getRepresentations();
        List scaledGases = gasInputs.stream().map(gas -> new GasStack((GasStack)gas, gas.getAmount() * 100L)).collect(Collectors.toList());
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initChemical(gasStacks, 0, true, this.inputGauge, scaledGases);
        BoxedChemicalStack outputDefinition = recipe.getOutputDefinition();
        ChemicalType chemicalType = outputDefinition.getChemicalType();
        if (chemicalType == ChemicalType.GAS) {
            this.initChemicalOutput(recipeLayout, MekanismJEI.TYPE_GAS, (GasStack)outputDefinition.getChemicalStack());
        } else if (chemicalType == ChemicalType.INFUSION) {
            this.initChemicalOutput(recipeLayout, MekanismJEI.TYPE_INFUSION, (InfusionStack)outputDefinition.getChemicalStack());
        } else if (chemicalType == ChemicalType.PIGMENT) {
            this.initChemicalOutput(recipeLayout, MekanismJEI.TYPE_PIGMENT, (PigmentStack)outputDefinition.getChemicalStack());
        } else if (chemicalType == ChemicalType.SLURRY) {
            this.initChemicalOutput(recipeLayout, MekanismJEI.TYPE_SLURRY, (SlurryStack)outputDefinition.getChemicalStack());
        } else {
            throw new IllegalStateException("Unknown chemical type");
        }
    }

    private <STACK extends ChemicalStack<?>> void initChemicalOutput(IRecipeLayout recipeLayout, IIngredientType<STACK> type, STACK stack) {
        this.initChemical(recipeLayout.getIngredientsGroup(type), 1, false, this.outputGauge, Collections.singletonList(stack));
    }
}

