/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class BoilerRecipeCategory
extends BaseRecipeCategory<BoilerJEIRecipe> {
    private static final ResourceLocation iconRL = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "heat.png");
    private final GuiGauge<?> superHeatedCoolantTank;
    private final GuiGauge<?> waterTank;
    private final GuiGauge<?> steamTank;
    private final GuiGauge<?> cooledCoolantTank;
    @Nullable
    private BoilerJEIRecipe recipe;

    public BoilerRecipeCategory(IGuiHelper helper, ResourceLocation id) {
        super(helper, id, (ITextComponent)MekanismLang.BOILER.translate(new Object[0]), BoilerRecipeCategory.createIcon(helper, iconRL), 6, 13, 180, 60);
        this.addElement(new GuiInnerScreen((IGuiWrapper)this, 48, 23, 96, 40, () -> {
            int boilRate;
            double temperature;
            if (this.recipe == null) {
                temperature = 300.0;
                boilRate = 0;
            } else {
                temperature = this.recipe.temperature;
                boilRate = MathUtils.clampToInt(this.recipe.steam.getAmount());
            }
            return Arrays.asList(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(temperature, UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.BOIL_RATE.translate(TextUtils.format(boilRate)));
        }));
        this.superHeatedCoolantTank = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 6, 13).setLabel((ITextComponent)MekanismLang.BOILER_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE, new Object[0])));
        this.waterTank = this.addElement(GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 26, 13).setLabel((ITextComponent)MekanismLang.BOILER_WATER_TANK.translateColored(EnumColor.INDIGO, new Object[0])));
        this.steamTank = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 148, 13).setLabel((ITextComponent)MekanismLang.BOILER_STEAM_TANK.translateColored(EnumColor.GRAY, new Object[0])));
        this.cooledCoolantTank = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 168, 13).setLabel((ITextComponent)MekanismLang.BOILER_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
    }

    @Nonnull
    public Class<? extends BoilerJEIRecipe> getRecipeClass() {
        return BoilerJEIRecipe.class;
    }

    @Override
    public void draw(BoilerJEIRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.recipe = recipe;
        super.draw(recipe, matrixStack, mouseX, mouseY);
        if (recipe.superHeatedCoolant == null) {
            this.superHeatedCoolantTank.drawBarOverlay(matrixStack);
            this.cooledCoolantTank.drawBarOverlay(matrixStack);
        }
        this.recipe = null;
    }

    public void setIngredients(BoilerJEIRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.water.getRepresentations()));
        if (recipe.superHeatedCoolant == null) {
            ingredients.setOutput(MekanismJEI.TYPE_GAS, (Object)recipe.steam);
        } else {
            ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(recipe.superHeatedCoolant.getRepresentations()));
            ingredients.setOutputs(MekanismJEI.TYPE_GAS, Arrays.asList(recipe.steam, recipe.cooledCoolant));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, BoilerJEIRecipe recipe, @Nonnull IIngredients ingredients) {
        this.initFluid(recipeLayout.getFluidStacks(), 0, true, this.waterTank, recipe.water.getRepresentations());
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        if (recipe.superHeatedCoolant == null) {
            this.initChemical(gasStacks, 0, false, this.steamTank, Collections.singletonList(recipe.steam));
        } else {
            this.initChemical(gasStacks, 0, true, this.superHeatedCoolantTank, recipe.superHeatedCoolant.getRepresentations());
            this.initChemical(gasStacks, 1, false, this.steamTank, Collections.singletonList(recipe.steam));
            this.initChemical(gasStacks, 2, false, this.cooledCoolantTank, Collections.singletonList(recipe.cooledCoolant));
        }
    }

    public static List<BoilerJEIRecipe> getBoilerRecipes() {
        int waterAmount = 1;
        double waterToSteamEfficiency = HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
        ArrayList<BoilerJEIRecipe> recipes = new ArrayList<BoilerJEIRecipe>();
        double temperature = (double)waterAmount * waterToSteamEfficiency / (50.0 * MekanismConfig.general.boilerWaterConductivity.get()) + HeatUtils.BASE_BOIL_TEMP;
        recipes.add(new BoilerJEIRecipe(null, FluidStackIngredient.from((ITag<Fluid>)FluidTags.field_206959_a, waterAmount), MekanismGases.STEAM.getStack(waterAmount), GasStack.EMPTY, temperature));
        for (Gas gas : MekanismAPI.gasRegistry()) {
            GasAttributes.HeatedCoolant heatedCoolant = gas.get(GasAttributes.HeatedCoolant.class);
            if (heatedCoolant == null) continue;
            Gas cooledCoolant = heatedCoolant.getCooledGas();
            long coolantAmount = Math.round((double)waterAmount * waterToSteamEfficiency / heatedCoolant.getThermalEnthalpy());
            recipes.add(new BoilerJEIRecipe(GasStackIngredient.from(gas, coolantAmount), FluidStackIngredient.from((ITag<Fluid>)FluidTags.field_206959_a, waterAmount), MekanismGases.STEAM.getStack(waterAmount), cooledCoolant.getStack(coolantAmount), HeatUtils.BASE_BOIL_TEMP));
        }
        return recipes;
    }

    public static class BoilerJEIRecipe {
        @Nullable
        private final GasStackIngredient superHeatedCoolant;
        private final FluidStackIngredient water;
        private final GasStack steam;
        private final GasStack cooledCoolant;
        private final double temperature;

        public BoilerJEIRecipe(@Nullable GasStackIngredient superHeatedCoolant, FluidStackIngredient water, GasStack steam, GasStack cooledCoolant, double temperature) {
            this.superHeatedCoolant = superHeatedCoolant;
            this.water = water;
            this.steam = steam;
            this.cooledCoolant = cooledCoolant;
            this.temperature = temperature;
        }
    }
}

