/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.client.jei.interfaces.IJEIRecipeArea;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.ResourceLocation;

public class GuiElementHandler
implements IGuiContainerHandler<GuiMekanism<?>> {
    private static boolean areaSticksOut(int x, int y, int width, int height, int parentX, int parentY, int parentWidth, int parentHeight) {
        return x < parentX || y < parentY || x + width > parentX + parentWidth || y + height > parentY + parentHeight;
    }

    public static List<Rectangle2d> getAreasFor(int parentX, int parentY, int parentWidth, int parentHeight, Collection<? extends IGuiEventListener> children) {
        ArrayList<Rectangle2d> areas = new ArrayList<Rectangle2d>();
        for (IGuiEventListener iGuiEventListener : children) {
            if (!(iGuiEventListener instanceof Widget)) continue;
            Widget widget = (Widget)iGuiEventListener;
            if (!widget.field_230694_p_) continue;
            if (GuiElementHandler.areaSticksOut(widget.field_230690_l_, widget.field_230691_m_, widget.func_230998_h_(), widget.func_238483_d_(), parentX, parentY, parentWidth, parentHeight)) {
                areas.add(new Rectangle2d(widget.field_230690_l_, widget.field_230691_m_, widget.func_230998_h_(), widget.func_238483_d_()));
            }
            if (!(widget instanceof GuiElement)) continue;
            for (Rectangle2d grandChildArea : GuiElementHandler.getAreasFor(widget.field_230690_l_, widget.field_230691_m_, widget.func_230998_h_(), widget.func_238483_d_(), ((GuiElement)widget).children())) {
                if (!GuiElementHandler.areaSticksOut(grandChildArea.func_199318_a(), grandChildArea.func_199319_b(), grandChildArea.func_199316_c(), grandChildArea.func_199317_d(), parentX, parentY, parentWidth, parentHeight)) continue;
                areas.add(grandChildArea);
            }
        }
        return areas;
    }

    public List<Rectangle2d> getGuiExtraAreas(GuiMekanism<?> gui) {
        int parentX = gui.getLeft();
        int parentY = gui.getTop();
        int parentWidth = gui.getWidth();
        int parentHeight = gui.getHeight();
        List<Rectangle2d> extraAreas = GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, gui.func_231039_at__());
        extraAreas.addAll(GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, gui.getWindows()));
        return extraAreas;
    }

    @Nullable
    public Object getIngredientUnderMouse(GuiMekanism<?> gui, double mouseX, double mouseY) {
        GuiWindow guiWindow = gui.getWindowHovering(mouseX, mouseY);
        return this.getIngredientUnderMouse(guiWindow == null ? gui.func_231039_at__() : guiWindow.children(), mouseX, mouseY);
    }

    @Nullable
    private Object getIngredientUnderMouse(List<? extends IGuiEventListener> children, double mouseX, double mouseY) {
        for (IGuiEventListener iGuiEventListener : children) {
            if (iGuiEventListener instanceof Widget) {
                GuiElement element;
                Object underGrandChild;
                Widget widget = (Widget)iGuiEventListener;
                if (!widget.field_230694_p_) continue;
                if (widget instanceof GuiElement && (underGrandChild = this.getIngredientUnderMouse((element = (GuiElement)widget).children(), mouseX, mouseY)) != null) {
                    return underGrandChild;
                }
            }
            if (!(iGuiEventListener instanceof IJEIIngredientHelper) || !iGuiEventListener.func_231047_b_(mouseX, mouseY)) continue;
            return ((IJEIIngredientHelper)iGuiEventListener).getIngredient(mouseX, mouseY);
        }
        return null;
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(GuiMekanism<?> gui, double mouseX, double mouseY) {
        GuiWindow guiWindow = gui.getWindowHovering(mouseX += (double)gui.getGuiLeft(), mouseY += (double)gui.getGuiTop());
        if (guiWindow == null) {
            return this.getGuiClickableArea(gui.func_231039_at__(), mouseX, mouseY);
        }
        return this.getGuiClickableArea(guiWindow.children(), mouseX, mouseY);
    }

    private Collection<IGuiClickableArea> getGuiClickableArea(List<? extends IGuiEventListener> children, double mouseX, double mouseY) {
        for (IGuiEventListener iGuiEventListener : children) {
            ResourceLocation[] categories;
            IJEIRecipeArea recipeArea;
            if (!(iGuiEventListener instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)iGuiEventListener;
            if (!element.field_230694_p_) continue;
            Collection<IGuiClickableArea> clickableGrandChildAreas = this.getGuiClickableArea(element.children(), mouseX, mouseY);
            if (!clickableGrandChildAreas.isEmpty()) {
                return clickableGrandChildAreas;
            }
            if (!(element instanceof IJEIRecipeArea) || !(recipeArea = (IJEIRecipeArea)((Object)element)).isActive() || (categories = recipeArea.getRecipeCategories()) == null || !recipeArea.isMouseOverJEIArea(mouseX, mouseY)) continue;
            IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)element.getRelativeX(), (int)element.getRelativeY(), (int)element.func_230998_h_(), (int)element.func_238483_d_(), (ResourceLocation[])categories);
            return Collections.singleton(clickableArea);
        }
        return Collections.emptyList();
    }
}

