/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalIconToggle;
import mekanism.client.gui.element.GuiDropdown;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.custom.GuiResizeControls;
import mekanism.client.gui.element.scroll.GuiSlotScroll;
import mekanism.client.gui.element.tab.window.GuiCraftingWindowTab;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiCraftingWindow;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.SearchQueryParser;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiQIOItemViewer<CONTAINER extends QIOItemViewerContainer>
extends GuiMekanism<CONTAINER> {
    private static final Set<Character> ALLOWED_SPECIAL_CHARS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('_'), Character.valueOf(' '), Character.valueOf('-'), Character.valueOf('/'), Character.valueOf('.'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('|'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(':')});
    private GuiTextField searchField;
    private GuiCraftingWindowTab craftingWindowTab;

    protected GuiQIOItemViewer(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 16 + MekanismConfig.client.qioItemViewerSlotsX.get() * 18 + 18;
        this.field_147000_g = 43 + MekanismConfig.client.qioItemViewerSlotsY.get() * 18 + 96;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.field_238743_q_ = 5;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        int slotsY = MekanismConfig.client.qioItemViewerSlotsY.get();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 7, 15, this.field_146999_f - 16, 12, () -> {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            Frequency.FrequencyIdentity freq = this.getFrequency();
            if (freq == null) {
                list.add(MekanismLang.NO_FREQUENCY.translate(new Object[0]));
            } else {
                list.add(MekanismLang.FREQUENCY.translate(freq.getKey()));
            }
            return list;
        }).tooltip(() -> {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            if (this.getFrequency() != null) {
                list.add(MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(((QIOItemViewerContainer)this.field_147002_h).getTotalItems()), TextUtils.format(((QIOItemViewerContainer)this.field_147002_h).getCountCapacity())));
                list.add(MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(((QIOItemViewerContainer)this.field_147002_h).getTotalTypes()), TextUtils.format(((QIOItemViewerContainer)this.field_147002_h).getTypeCapacity())));
            }
            return list;
        }));
        this.searchField = (GuiTextField)this.func_230480_a_(new GuiTextField(this, 50, 30, this.field_146999_f - 50 - 10, 10));
        this.searchField.setOffset(0, -1);
        this.searchField.setInputValidator(this::isValidSearchChar);
        this.searchField.setResponder(((QIOItemViewerContainer)this.field_147002_h)::updateSearch);
        this.searchField.setMaxStringLength(50);
        this.searchField.setBackground(BackgroundType.ELEMENT_HOLDER);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.func_230996_d_(true);
        this.func_230480_a_(new GuiSlotScroll(this, 7, 43, MekanismConfig.client.qioItemViewerSlotsX.get(), slotsY, ((QIOItemViewerContainer)this.field_147002_h)::getQIOItemList, (ISlotClickHandler)this.field_147002_h));
        this.func_230480_a_(new GuiDropdown<QIOItemViewerContainer.ListSortType>(this, this.field_146999_f - 9 - 54, 43 + slotsY * 18 + 1, 41, QIOItemViewerContainer.ListSortType.class, ((QIOItemViewerContainer)this.field_147002_h)::getSortType, ((QIOItemViewerContainer)this.field_147002_h)::setSortType));
        this.func_230480_a_(new GuiDigitalIconToggle<QIOItemViewerContainer.SortDirection>(this, this.field_146999_f - 9 - 12, 43 + slotsY * 18 + 1, 12, 12, QIOItemViewerContainer.SortDirection.class, ((QIOItemViewerContainer)this.field_147002_h)::getSortDirection, ((QIOItemViewerContainer)this.field_147002_h)::setSortDirection));
        this.func_230480_a_(new GuiResizeControls(this, this.getMinecraft().func_228018_at_().func_198087_p() / 2 - 20 - this.field_147009_r, this::resize));
        this.craftingWindowTab = (GuiCraftingWindowTab)this.func_230480_a_(new GuiCraftingWindowTab(this, () -> this.craftingWindowTab, (QIOItemViewerContainer)this.field_147002_h));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.LIST_SEARCH.translate(new Object[0]), 7.0f, 31.0f, this.titleTextColor(), 41.0f);
        TranslationTextComponent text = MekanismLang.LIST_SORT.translate(new Object[0]);
        this.drawString(matrix, (ITextComponent)text, this.field_146999_f - 66 - this.getStringWidth((ITextComponent)text), this.field_147000_g - 92, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public void func_231158_b_(@Nonnull Minecraft minecraft, int sizeX, int sizeY) {
        super.func_231158_b_(minecraft, sizeX, sizeY);
        ((QIOItemViewerContainer)this.field_147002_h).updateSearch(this.searchField.getText());
        int maxY = QIOItemViewerContainer.getSlotsYMax();
        if (MekanismConfig.client.qioItemViewerSlotsY.get() > maxY) {
            MekanismConfig.client.qioItemViewerSlotsY.set(maxY);
            MekanismConfig.client.getConfigSpec().save();
            this.recreateViewer();
        }
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    private boolean isValidSearchChar(char c) {
        return ALLOWED_SPECIAL_CHARS.contains(Character.valueOf(c)) || Character.isDigit(c) || Character.isAlphabetic(c);
    }

    public abstract Frequency.FrequencyIdentity getFrequency();

    private void resize(GuiResizeControls.ResizeType type) {
        int sizeX = MekanismConfig.client.qioItemViewerSlotsX.get();
        int sizeY = MekanismConfig.client.qioItemViewerSlotsY.get();
        boolean changed = false;
        if (type == GuiResizeControls.ResizeType.EXPAND_X && sizeX < 16) {
            MekanismConfig.client.qioItemViewerSlotsX.set(sizeX + 1);
            changed = true;
        } else if (type == GuiResizeControls.ResizeType.EXPAND_Y && sizeY < QIOItemViewerContainer.getSlotsYMax()) {
            MekanismConfig.client.qioItemViewerSlotsY.set(sizeY + 1);
            changed = true;
        } else if (type == GuiResizeControls.ResizeType.SHRINK_X && sizeX > 8) {
            MekanismConfig.client.qioItemViewerSlotsX.set(sizeX - 1);
            changed = true;
        } else if (type == GuiResizeControls.ResizeType.SHRINK_Y && sizeY > 2) {
            MekanismConfig.client.qioItemViewerSlotsY.set(sizeY - 1);
            changed = true;
        }
        if (changed) {
            MekanismConfig.client.getConfigSpec().save();
            this.recreateViewer();
        }
    }

    private void recreateViewer() {
        QIOItemViewerContainer c = ((QIOItemViewerContainer)this.field_147002_h).recreate();
        GuiQIOItemViewer<QIOItemViewerContainer> s = this.recreate(c);
        this.getMinecraft().field_71462_r = null;
        this.getMinecraft().field_71439_g.field_71070_bA = s.func_212873_a_();
        this.getMinecraft().func_147108_a(s);
        s.searchField.setText(this.searchField.getText());
        c.updateSearch(this.searchField.getText());
        s.transferWindows(this.windows);
    }

    protected void transferWindows(Collection<GuiWindow> windows) {
        for (GuiWindow window : windows) {
            if (window instanceof GuiCraftingWindow) {
                this.craftingWindowTab.adoptWindows(window);
                ((GuiCraftingWindow)window).updateContainer((QIOItemViewerContainer)this.field_147002_h);
            }
            this.addWindow(window);
            window.transferToNewGui(this);
        }
    }

    public abstract GuiQIOItemViewer<CONTAINER> recreate(CONTAINER var1);

    static {
        ALLOWED_SPECIAL_CHARS.addAll((Collection<Character>)SearchQueryParser.QueryType.getPrefixChars());
    }
}

