/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.lib.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class GuiRobitSkinSelectScroll
extends GuiElement {
    private static final int SLOT_DIMENSIONS = 48;
    private static final int SLOT_COUNT = 3;
    private static final int INNER_DIMENSIONS = 144;
    private final GuiScrollBar scrollBar;
    private final Supplier<List<RobitSkin>> unlockedSkins;
    private final EntityRobit robit;
    private RobitSkin selectedSkin;
    private float rotation;
    private int ticks;

    public GuiRobitSkinSelectScroll(IGuiWrapper gui, int x, int y, EntityRobit robit, Supplier<List<RobitSkin>> unlockedSkins) {
        super(gui, x, y, 156, 144);
        this.robit = robit;
        this.selectedSkin = this.robit.getSkin();
        this.unlockedSkins = unlockedSkins;
        this.scrollBar = this.addChild(new GuiScrollBar(gui, this.relativeX + 144, y, 144, () -> this.getUnlockedSkins() == null ? 0 : (int)Math.ceil((double)this.getUnlockedSkins().size() / 3.0), () -> 3));
    }

    private List<RobitSkin> getUnlockedSkins() {
        return this.unlockedSkins.get();
    }

    public RobitSkin getSelectedSkin() {
        return this.selectedSkin;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int index = this.ticks / 10;
            float oldRot = this.rotation;
            this.rotation = MathHelper.func_76142_g((float)(this.rotation - 0.5f));
            float rot = MathHelper.func_219805_h((float)partialTicks, (float)oldRot, (float)this.rotation);
            int slotStart = this.scrollBar.getCurrentSelection() * 3;
            int max = 9;
            for (int i = 0; i < max; ++i) {
                int slotX = this.field_230690_l_ + i % 3 * 48;
                int slotY = this.field_230691_m_ + i / 3 * 48;
                int slot = slotStart + i;
                if (slot < skins.size()) {
                    RobitSkin skin = skins.get(slot);
                    if (skin == this.selectedSkin) {
                        GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE);
                    } else {
                        GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiElementHolder.HOLDER, 32);
                    }
                    this.renderRobit(matrix, skins.get(slot), slotX, slotY, rot, index);
                    continue;
                }
                GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiElementHolder.HOLDER, 32);
            }
        }
    }

    private static void renderSlotBackground(@Nonnull MatrixStack matrix, int slotX, int slotY, ResourceLocation resource, int size) {
        GuiUtils.renderBackgroundTexture(matrix, resource, size, size, slotX, slotY, 48, 48, 256, 256);
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int xAxis = mouseX - this.getGuiLeft();
            int yAxis = mouseY - this.getGuiTop();
            int slotX = (xAxis - this.relativeX) / 48;
            int slotY = (yAxis - this.relativeY) / 48;
            if (slotX >= 0 && slotY >= 0 && slotX < 3 && slotY < 3) {
                int slot;
                int slotStartX = this.relativeX + slotX * 48;
                int slotStartY = this.relativeY + slotY * 48;
                if (xAxis >= slotStartX && xAxis < slotStartX + 48 && yAxis >= slotStartY && yAxis < slotStartY + 48 && (slot = (slotY + this.scrollBar.getCurrentSelection()) * 3 + slotX) < skins.size()) {
                    GuiRobitSkinSelectScroll.func_238467_a_((MatrixStack)matrix, (int)slotStartX, (int)slotStartY, (int)(slotStartX + 48), (int)(slotStartY + 48), (int)1895819776);
                    MekanismRenderer.resetColor();
                }
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ticks;
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        RobitSkin skin = this.getSkin(mouseX, mouseY, this.relativeX, this.relativeY);
        if (skin != null) {
            this.displayTooltip(matrix, (ITextComponent)MekanismLang.ROBIT_SKIN.translate(skin), mouseX, mouseY);
        }
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.func_231043_a_(mouseX, mouseY, delta);
    }

    @Override
    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_231000_a__(mouseX, mouseY);
        RobitSkin skin = this.getSkin(mouseX, mouseY, this.field_230690_l_, this.field_230691_m_);
        if (skin != null) {
            this.selectedSkin = skin;
        }
    }

    private RobitSkin getSkin(double mouseX, double mouseY, int relativeX, int relativeY) {
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int slot;
            int slotX = (int)((mouseX - (double)relativeX) / 48.0);
            int slotY = (int)((mouseY - (double)relativeY) / 48.0);
            if (slotX >= 0 && slotY >= 0 && slotX < 3 && slotY < 3 && (slot = (slotY + this.scrollBar.getCurrentSelection()) * 3 + slotX) < skins.size()) {
                return skins.get(slot);
            }
        }
        return null;
    }

    private void renderRobit(MatrixStack matrix, RobitSkin skin, int x, int y, float rotation, int index) {
        List<ResourceLocation> textures = skin.getTextures();
        if (textures.isEmpty()) {
            Mekanism.logger.error("Failed to render skin: {}, as it has no textures.", (Object)skin.getRegistryName());
            return;
        }
        IBakedModel model = MekanismModelCache.INSTANCE.getRobitSkin(skin);
        if (model == null) {
            Mekanism.logger.warn("Failed to render skin: {} as it does not have a model.", (Object)skin.getRegistryName());
            return;
        }
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(RobitSpriteUploader.RENDER_TYPE);
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)(x + 48), (double)(y + 38), 0.0);
        matrix.func_227862_a_(48.0f, 48.0f, 48.0f);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        MatrixStack.Entry matrixEntry = matrix.func_227866_c_();
        ModelDataMap modelData = new ModelDataMap.Builder().withInitial(EntityRobit.SKIN_TEXTURE_PROPERTY, (Object)MathUtils.getByIndexMod(textures, index)).build();
        List<BakedQuad> quads = model.getQuads(null, null, this.robit.field_70170_p.field_73012_v, (IModelData)modelData);
        quads = QuadUtils.transformBakedQuads(quads, new BasicRotationTransformation(rotation));
        for (BakedQuad quad : quads) {
            builder.addVertexData(matrixEntry, quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.field_229196_a_);
        }
        buffer.func_228462_a_(RobitSpriteUploader.RENDER_TYPE);
        matrix.func_227865_b_();
    }

    private static class BasicRotationTransformation
    implements QuadTransformation {
        private static final double EPSILON = 10000.0;
        private static final Vector3d NORMAL = new Vector3d(0.0, 1.0, 0.0);
        private final Quaternion quaternion;

        public BasicRotationTransformation(float rotation) {
            this.quaternion = new Quaternion(0.0, (double)rotation, 0.0, true);
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(this::consumeVertex);
        }

        private void consumeVertex(Vertex v) {
            v.pos(BasicRotationTransformation.round(this.quaternion.rotate(v.getPos().func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5)));
            v.normal(NORMAL);
        }

        private static Vector3d round(Vector3d vec) {
            return new Vector3d((double)Math.round(vec.field_72450_a * 10000.0) / 10000.0, (double)Math.round(vec.field_72448_b * 10000.0) / 10000.0, (double)Math.round(vec.field_72449_c * 10000.0) / 10000.0);
        }

        public boolean equals(Object other) {
            return other instanceof BasicRotationTransformation && this.quaternion.equals(((BasicRotationTransformation)other).quaternion);
        }

        public int hashCode() {
            return this.quaternion.hashCode();
        }
    }
}

