/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDigitalBar;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.util.text.TextUtils;
import net.minecraft.util.text.ITextComponent;

public class GuiQIOFrequencyDataScreen
extends GuiInnerScreen {
    private final Supplier<QIOFrequency> frequencySupplier;

    public GuiQIOFrequencyDataScreen(IGuiWrapper gui, int x, int y, int width, int height, final Supplier<QIOFrequency> frequencySupplier) {
        super(gui, x, y, width, height);
        this.frequencySupplier = frequencySupplier;
        this.field_230693_o_ = true;
        this.addChild(new GuiDigitalBar(gui, new GuiBar.IBarInfoHandler(){

            @Override
            public double getLevel() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? 0.0 : (double)freq.getTotalItemCount() / (double)freq.getTotalItemCountCapacity();
            }

            @Override
            public ITextComponent getTooltip() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? null : MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemCount()), TextUtils.format(freq.getTotalItemCountCapacity()));
            }
        }, this.relativeX + width / 4 - 25, this.relativeY + 20, 50));
        this.addChild(new GuiDigitalBar(gui, new GuiBar.IBarInfoHandler(){

            @Override
            public double getLevel() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? 0.0 : (double)freq.getTotalItemTypes(true) / (double)freq.getTotalItemTypeCapacity();
            }

            @Override
            public ITextComponent getTooltip() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? null : MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemTypes(true)), TextUtils.format(freq.getTotalItemTypeCapacity()));
            }
        }, this.relativeX + 3 * width / 4 - 25, this.relativeY + 20, 50));
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        QIOFrequency freq = this.frequencySupplier.get();
        if (freq != null) {
            this.drawScaledTextScaledBound(matrix, (ITextComponent)MekanismLang.FREQUENCY.translate(freq.getName()), this.relativeX + 5, this.relativeY + 5, this.screenTextColor(), this.field_230688_j_ - 10, 0.8f);
        }
        this.drawScaledCenteredText(matrix, (ITextComponent)MekanismLang.QIO_ITEMS.translate(new Object[0]), this.relativeX + this.field_230688_j_ / 4, this.relativeY + 32, this.screenTextColor(), 0.8f);
        this.drawScaledCenteredText(matrix, (ITextComponent)MekanismLang.QIO_TYPES.translate(new Object[0]), this.relativeX + 3 * this.field_230688_j_ / 4, this.relativeY + 32, this.screenTextColor(), 0.8f);
    }
}

