/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.heat;

import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class HeatAPI {
    public static final double AMBIENT_TEMP = 300.0;
    public static final double AIR_INVERSE_COEFFICIENT = 10000.0;
    public static final double DEFAULT_HEAT_CAPACITY = 1.0;
    public static final double DEFAULT_INVERSE_CONDUCTION = 1.0;
    public static final double DEFAULT_INVERSE_INSULATION = 0.0;

    private HeatAPI() {
    }

    public static double getAmbientTemp(@Nullable IWorldReader world, BlockPos pos) {
        if (world == null) {
            return 300.0;
        }
        return HeatAPI.getAmbientTemp(world.func_226691_t_(pos).func_225486_c(pos));
    }

    public static double getAmbientTemp(double biomeTemp) {
        biomeTemp = Math.max(Math.min(biomeTemp, 5.0), -5.0);
        return 300.0 + 25.0 * (biomeTemp - 0.8);
    }

    public static class HeatTransfer {
        private final double adjacentTransfer;
        private final double environmentTransfer;

        public HeatTransfer(double adjacentTransfer, double environmentTransfer) {
            this.adjacentTransfer = adjacentTransfer;
            this.environmentTransfer = environmentTransfer;
        }

        public double getAdjacentTransfer() {
            return this.adjacentTransfer;
        }

        public double getEnvironmentTransfer() {
            return this.environmentTransfer;
        }
    }
}

