/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalChemicalToChemicalRecipeBuilder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipeBuilder<ChemicalChemicalToChemicalRecipeBuilder<CHEMICAL, STACK, INGREDIENT>> {
    private final ChemicalIngredientDeserializer<CHEMICAL, STACK, ?> outputSerializer;
    private final INGREDIENT leftInput;
    private final INGREDIENT rightInput;
    private final STACK output;

    protected ChemicalChemicalToChemicalRecipeBuilder(ResourceLocation serializerName, INGREDIENT leftInput, INGREDIENT rightInput, STACK output, ChemicalIngredientDeserializer<CHEMICAL, STACK, ?> outputSerializer) {
        super(serializerName);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.output = output;
        this.outputSerializer = outputSerializer;
    }

    public static ChemicalChemicalToChemicalRecipeBuilder<Gas, GasStack, GasStackIngredient> chemicalInfusing(GasStackIngredient leftInput, GasStackIngredient rightInput, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This chemical infusing recipe requires a non empty gas output.");
        }
        return new ChemicalChemicalToChemicalRecipeBuilder<Gas, GasStack, GasStackIngredient>(ChemicalChemicalToChemicalRecipeBuilder.mekSerializer("chemical_infusing"), leftInput, rightInput, output, ChemicalIngredientDeserializer.GAS);
    }

    public static ChemicalChemicalToChemicalRecipeBuilder<Pigment, PigmentStack, PigmentStackIngredient> pigmentMixing(PigmentStackIngredient leftInput, PigmentStackIngredient rightInput, PigmentStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This pigment mixing recipe requires a non empty gas output.");
        }
        return new ChemicalChemicalToChemicalRecipeBuilder<Pigment, PigmentStack, PigmentStackIngredient>(ChemicalChemicalToChemicalRecipeBuilder.mekSerializer("pigment_mixing"), leftInput, rightInput, output, ChemicalIngredientDeserializer.PIGMENT);
    }

    @Override
    protected ChemicalChemicalToChemicalRecipeResult getResult(ResourceLocation id) {
        return new ChemicalChemicalToChemicalRecipeResult(id);
    }

    public class ChemicalChemicalToChemicalRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected ChemicalChemicalToChemicalRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("leftInput", ChemicalChemicalToChemicalRecipeBuilder.this.leftInput.serialize());
            json.add("rightInput", ChemicalChemicalToChemicalRecipeBuilder.this.rightInput.serialize());
            json.add("output", (JsonElement)ChemicalChemicalToChemicalRecipeBuilder.this.outputSerializer.serializeStack(ChemicalChemicalToChemicalRecipeBuilder.this.output));
        }
    }
}

