/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.util.Platform;
import appeng.util.item.AEItemStackRegistry;
import appeng.util.item.AESharedItemStack;
import appeng.util.item.AEStack;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack {
    private static final String NBT_STACKSIZE = "cnt";
    private static final String NBT_REQUESTABLE = "req";
    private static final String NBT_CRAFTABLE = "craft";
    private static final String NBT_ITEMSTACK = "is";
    private final AESharedItemStack sharedStack;
    @OnlyIn(value=Dist.CLIENT)
    private ITextComponent displayName;
    @OnlyIn(value=Dist.CLIENT)
    private List<ITextComponent> tooltip;

    private AEItemStack(AEItemStack is) {
        this.setStackSize(is.getStackSize());
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
        this.sharedStack = is.sharedStack;
    }

    private AEItemStack(AESharedItemStack is, long size) {
        this.sharedStack = is;
        this.setStackSize(size);
        this.setCraftable(false);
        this.setCountRequestable(0L);
    }

    @Nullable
    public static AEItemStack fromItemStack(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new AEItemStack(AEItemStackRegistry.getRegisteredStack(stack), stack.func_190916_E());
    }

    public static IAEItemStack fromNBT(CompoundNBT i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)i.func_74775_l(NBT_ITEMSTACK));
        AEItemStack item = AEItemStack.fromItemStack(itemstack);
        if (item == null) {
            return null;
        }
        item.setStackSize(i.func_74763_f(NBT_STACKSIZE));
        item.setCountRequestable(i.func_74763_f(NBT_REQUESTABLE));
        item.setCraftable(i.func_74767_n(NBT_CRAFTABLE));
        return item;
    }

    @Override
    public void writeToNBT(CompoundNBT i) {
        CompoundNBT itemStack = new CompoundNBT();
        this.getDefinition().func_77955_b(itemStack);
        i.func_218657_a(NBT_ITEMSTACK, (INBT)itemStack);
        i.func_74772_a(NBT_STACKSIZE, this.getStackSize());
        i.func_74772_a(NBT_REQUESTABLE, this.getCountRequestable());
        i.func_74757_a(NBT_CRAFTABLE, this.isCraftable());
    }

    public static AEItemStack fromPacket(PacketBuffer buffer) {
        boolean isCraftable = buffer.readBoolean();
        long stackSize = buffer.func_179260_f();
        long countRequestable = buffer.func_179260_f();
        ItemStack itemstack = buffer.func_150791_c();
        if (itemstack.func_190926_b()) {
            return null;
        }
        AEItemStack item = new AEItemStack(AEItemStackRegistry.getRegisteredStack(itemstack), stackSize);
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        return item;
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        buffer.writeBoolean(this.isCraftable());
        buffer.func_179254_b(this.getStackSize());
        buffer.func_179254_b(this.getCountRequestable());
        buffer.writeItemStack(this.getDefinition(), true);
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public boolean fuzzyComparison(IAEItemStack other, FuzzyMode mode) {
        ItemStack itemStack = this.getDefinition();
        ItemStack otherStack = other.getDefinition();
        return this.fuzzyItemStackComparison(itemStack, otherStack, mode);
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public ItemStack createItemStack() {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)this.getDefinition(), (int)((int)Math.min(Integer.MAX_VALUE, this.getStackSize())));
    }

    @Override
    public Item getItem() {
        return this.getDefinition().func_77973_b();
    }

    @Override
    public int getItemDamage() {
        return this.sharedStack.getItemDamage();
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return Objects.equals(this.sharedStack, ((AEItemStack)otherStack).sharedStack);
    }

    @Override
    public boolean isSameType(ItemStack otherStack) {
        if (otherStack.func_190926_b()) {
            return false;
        }
        int oldSize = otherStack.func_190916_E();
        otherStack.func_190920_e(1);
        boolean ret = ItemStack.func_77989_b((ItemStack)this.getDefinition(), (ItemStack)otherStack);
        otherStack.func_190920_e(oldSize);
        return ret;
    }

    public int hashCode() {
        return this.sharedStack.hashCode();
    }

    @Override
    public boolean equals(Object ia) {
        if (ia instanceof AEItemStack) {
            return this.isSameType((AEItemStack)ia);
        }
        if (ia instanceof ItemStack) {
            return this.equals((ItemStack)ia);
        }
        return false;
    }

    @Override
    public boolean equals(ItemStack is) {
        return this.isSameType(is);
    }

    public String toString() {
        return this.getStackSize() + "x" + this.getDefinition().func_77973_b().getRegistryName();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getToolTip() {
        if (this.tooltip == null) {
            this.tooltip = Platform.getTooltip(this.asItemStackRepresentation());
        }
        return this.tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Platform.getItemDisplayName(this.asItemStackRepresentation());
        }
        return this.displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getModID() {
        return this.getDefinition().func_77973_b().getRegistryName().func_110624_b();
    }

    @Override
    public boolean hasTagCompound() {
        return this.getDefinition().func_77942_o();
    }

    @Override
    public ItemStack asItemStackRepresentation() {
        return this.getDefinition().func_77946_l();
    }

    @Override
    public ItemStack getDefinition() {
        return this.sharedStack.getDefinition();
    }

    AESharedItemStack getSharedStack() {
        return this.sharedStack;
    }

    private boolean fuzzyItemStackComparison(ItemStack a, ItemStack b, FuzzyMode mode) {
        if (a.func_77973_b() == b.func_77973_b() && a.func_77973_b().func_77645_m()) {
            if (mode == FuzzyMode.IGNORE_ALL) {
                return true;
            }
            if (mode == FuzzyMode.PERCENT_99) {
                return a.func_77952_i() > 1 == b.func_77952_i() > 1;
            }
            float percentDamageOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
            float percentDamageOfB = (float)b.func_77952_i() / (float)b.func_77958_k();
            return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
        }
        return false;
    }
}

