/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.FuzzyMode;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.AdaptorItemHandlerPlayerInv;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class InventoryAdaptor
implements Iterable<ItemSlot> {
    public static InventoryAdaptor getAdaptor(TileEntity te, Direction d) {
        LazyOptional cap;
        if (te != null && (cap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d)).isPresent()) {
            return new AdaptorItemHandler((IItemHandler)cap.orElseThrow(IllegalStateException::new));
        }
        return null;
    }

    public static InventoryAdaptor getAdaptor(PlayerEntity te) {
        if (te != null) {
            return new AdaptorItemHandlerPlayerInv(te);
        }
        return null;
    }

    public abstract ItemStack removeItems(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack simulateRemove(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack removeSimilarItems(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack simulateSimilarRemove(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack addItems(ItemStack var1);

    public abstract ItemStack simulateAdd(ItemStack var1);

    public abstract boolean containsItems();

    public abstract boolean hasSlots();
}

