/*
 * Decompiled with CFR 0.152.
 */
package appeng.thirdparty.codechicken.lib.model.pipeline.transformers;

import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.IPipelineElementFactory;
import appeng.thirdparty.codechicken.lib.model.pipeline.QuadTransformer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class QuadFaceStripper
extends QuadTransformer {
    public static final IPipelineElementFactory<QuadFaceStripper> FACTORY = QuadFaceStripper::new;
    private AxisAlignedBB bounds;
    private int mask;

    QuadFaceStripper() {
    }

    public QuadFaceStripper(IVertexConsumer parent, AxisAlignedBB bounds, int mask) {
        super(parent);
        this.bounds = bounds;
        this.mask = mask;
    }

    public void setBounds(AxisAlignedBB bounds) {
        this.bounds = bounds;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    @Override
    public boolean transform() {
        if (this.mask == 0) {
            return true;
        }
        if ((this.mask & 1 << this.quad.orientation.ordinal()) != 0) {
            Direction.AxisDirection dir = this.quad.orientation.func_176743_c();
            Quad.Vertex[] vertices = this.quad.vertices;
            switch (this.quad.orientation.func_176740_k()) {
                case X: {
                    float bound = (float)(dir == Direction.AxisDirection.POSITIVE ? this.bounds.field_72336_d : this.bounds.field_72340_a);
                    float x1 = vertices[0].vec[0];
                    float x2 = vertices[1].vec[0];
                    float x3 = vertices[2].vec[0];
                    float x4 = vertices[3].vec[0];
                    return x1 != x2 || x2 != x3 || x3 != x4 || x4 != bound;
                }
                case Y: {
                    float bound = (float)(dir == Direction.AxisDirection.POSITIVE ? this.bounds.field_72337_e : this.bounds.field_72338_b);
                    float y1 = vertices[0].vec[1];
                    float y2 = vertices[1].vec[1];
                    float y3 = vertices[2].vec[1];
                    float y4 = vertices[3].vec[1];
                    return y1 != y2 || y2 != y3 || y3 != y4 || y4 != bound;
                }
                case Z: {
                    float bound = (float)(dir == Direction.AxisDirection.POSITIVE ? this.bounds.field_72334_f : this.bounds.field_72339_c);
                    float z1 = vertices[0].vec[2];
                    float z2 = vertices[1].vec[2];
                    float z3 = vertices[2].vec[2];
                    float z4 = vertices[3].vec[2];
                    return z1 != z2 || z2 != z3 || z3 != z4 || z4 != bound;
                }
            }
        }
        return true;
    }
}

