/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.Api;
import appeng.core.worlddata.WorldData;
import appeng.items.storage.SpatialStorageCellItem;
import appeng.server.ISubCommand;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import appeng.spatial.TransitionInfo;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SpatialStorageCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").executes(ctx -> {
            SpatialStorageCommand.showPlotInfo((CommandSource)ctx.getSource(), SpatialStorageCommand.getCurrentPlot((CommandSource)ctx.getSource()));
            return 1;
        })).then(Commands.func_197056_a((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.showPlotInfo((CommandSource)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(Commands.func_197057_a((String)"tp").then(Commands.func_197056_a((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.teleportToPlot((CommandSource)ctx.getSource(), plotId);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpback").executes(ctx -> {
            this.teleportBack((CommandSource)ctx.getSource());
            return 1;
        })).then(Commands.func_197056_a((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.teleportBack((CommandSource)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(Commands.func_197057_a((String)"givecell").then(Commands.func_197056_a((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.giveCell((CommandSource)ctx.getSource(), plotId);
            return 1;
        })));
    }

    private void teleportBack(CommandSource source) {
        if (source.func_197023_e().func_234923_W_() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new CommandException((ITextComponent)new StringTextComponent("Must be within the spatial storage world."));
        }
        BlockPos playerPos = new BlockPos(source.func_197036_d());
        int x = playerPos.func_177958_n();
        int z = playerPos.func_177952_p();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            BlockPos origin = plot.getOrigin();
            BlockPos size = plot.getSize();
            if (x < origin.func_177958_n() || x > origin.func_177958_n() + size.func_177958_n() || z < origin.func_177952_p() || z > origin.func_177952_p() + size.func_177952_p()) continue;
            this.teleportBack(source, plot);
            return;
        }
        throw new CommandException((ITextComponent)new StringTextComponent("Couldn't find a plot for the current position."));
    }

    private void teleportBack(CommandSource source, SpatialStoragePlot plot) {
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition == null) {
            throw new CommandException((ITextComponent)new StringTextComponent("This plot doesn't have a last known transition."));
        }
        String command = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().func_177982_a(0, 1, 0));
        SpatialStorageCommand.runCommandFor(source, command);
    }

    private static void showPlotInfo(CommandSource source, SpatialStoragePlot plot) {
        SpatialStorageCommand.sendKeyValuePair(source, "Plot ID", String.valueOf(plot.getId()));
        int playerId = plot.getOwner();
        if (playerId != -1) {
            UUID profileId = WorldData.instance().playerData().getProfileId(playerId);
            if (profileId == null) {
                SpatialStorageCommand.sendKeyValuePair(source, "Owner", "Unknown AE2 player (" + playerId + ")");
            } else {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                ServerPlayerEntity player = server.func_184103_al().func_177451_a(profileId);
                if (player == null) {
                    SpatialStorageCommand.sendKeyValuePair(source, "Owner", "Unknown Minecraft profile (" + profileId + ")");
                } else {
                    SpatialStorageCommand.sendKeyValuePair(source, "Owner", player.func_145748_c_());
                }
            }
        } else {
            SpatialStorageCommand.sendKeyValuePair(source, "Owner", "Unknown");
        }
        SpatialStorageCommand.sendKeyValuePair(source, "Size", SpatialStorageCommand.formatBlockPos(plot.getSize(), "x"));
        String teleportToPlotCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.func_240901_a_(), plot.getOrigin());
        SpatialStorageCommand.sendKeyValuePair(source, "Origin", (ITextComponent)new StringTextComponent(SpatialStorageCommand.formatBlockPos(plot.getOrigin(), ",")).func_240700_a_(SpatialStorageCommand.makeCommandLink(teleportToPlotCommand, "Teleport into plot")));
        SpatialStorageCommand.sendKeyValuePair(source, "Region file:", plot.getRegionFilename());
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition != null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Last Transition:").func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.BOLD}), true);
            String sourceWorldId = lastTransition.getWorldId().toString();
            StringTextComponent sourceLink = new StringTextComponent(sourceWorldId + " - " + SpatialStorageCommand.formatBlockPos(lastTransition.getMin(), ",") + " to " + SpatialStorageCommand.formatBlockPos(lastTransition.getMax(), ","));
            String tpCommand = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().func_177982_a(0, 1, 0));
            sourceLink.func_240700_a_(SpatialStorageCommand.makeCommandLink(tpCommand, "Click to teleport"));
            SpatialStorageCommand.sendKeyValuePair(source, "Source", (ITextComponent)sourceLink);
            SpatialStorageCommand.sendKeyValuePair(source, "When", lastTransition.getTimestamp().toString());
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("Last Transition unknown"), true);
        }
    }

    private static void teleportToPlot(CommandSource source, int plotId) {
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        String teleportCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.func_240901_a_(), plot.getOrigin());
        SpatialStorageCommand.runCommandFor(source, teleportCommand);
    }

    private void giveCell(CommandSource source, int plotId) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        int longestSide = SpatialStorageCommand.getLongestSide(plot.getSize());
        ItemStack cell = longestSide <= 2 ? Api.instance().definitions().items().spatialCell2().stack(1) : (longestSide <= 16 ? Api.instance().definitions().items().spatialCell16().stack(1) : Api.instance().definitions().items().spatialCell128().stack(1));
        if (!(cell.func_77973_b() instanceof SpatialStorageCellItem)) {
            throw new CommandException((ITextComponent)new StringTextComponent("Storage cell items don't implement the storage cell interface!"));
        }
        SpatialStorageCellItem spatialCellItem = (SpatialStorageCellItem)cell.func_77973_b();
        spatialCellItem.setStoredDimension(cell, plotId, plot.getSize());
        player.func_191521_c(cell);
    }

    private static int getLongestSide(BlockPos size) {
        return Math.max(size.func_177958_n(), Math.max(size.func_177956_o(), size.func_177952_p()));
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSource> ctx, CommandSource sender) {
        ArrayList<SpatialStoragePlot> plots = new ArrayList<SpatialStoragePlot>(SpatialStoragePlotManager.INSTANCE.getPlots());
        plots.sort(Comparator.comparing(plot -> {
            TransitionInfo lastTransition = plot.getLastTransition();
            if (lastTransition != null) {
                return lastTransition.getTimestamp();
            }
            return Instant.MIN;
        }).reversed());
        for (int i = 0; i < Math.min(5, plots.size()); ++i) {
            SpatialStoragePlot plot2 = (SpatialStoragePlot)plots.get(i);
            String size = SpatialStorageCommand.formatBlockPos(plot2.getSize(), "x");
            BlockPos originPos = plot2.getOrigin();
            String origin = SpatialStorageCommand.formatBlockPos(originPos, ",");
            IFormattableTextComponent infoLink = new StringTextComponent("Plot #" + plot2.getId()).func_240700_a_(SpatialStorageCommand.makeCommandLink("/ae2 spatial info " + plot2.getId(), "Click to show details"));
            IFormattableTextComponent tpLink = new StringTextComponent("Origin: " + origin).func_240700_a_(SpatialStorageCommand.makeCommandLink("/ae2 spatial tp " + plot2.getId(), "Click to teleport into plot"));
            IFormattableTextComponent message = new StringTextComponent("").func_230529_a_((ITextComponent)infoLink).func_240702_b_(" Size: " + size + " ").func_230529_a_((ITextComponent)tpLink);
            sender.func_197030_a((ITextComponent)message, true);
        }
    }

    private static String formatBlockPos(BlockPos size, String separator) {
        return size.func_177958_n() + separator + size.func_177956_o() + separator + size.func_177952_p();
    }

    private static UnaryOperator<Style> makeCommandLink(String command, String tooltip) {
        return style -> style.func_240721_b_(TextFormatting.UNDERLINE).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(tooltip)));
    }

    private static void runCommandFor(CommandSource source, String command) {
        Commands commandManager = ServerLifecycleHooks.getCurrentServer().func_195571_aL();
        commandManager.func_197059_a(source, command);
    }

    private static String getTeleportCommand(ResourceLocation worldId, BlockPos pos) {
        return "/execute in " + worldId + " run tp @s " + pos.func_177958_n() + " " + (pos.func_177956_o() + 1) + " " + pos.func_177952_p();
    }

    private static SpatialStoragePlot getPlot(int plotId) {
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(plotId);
        if (plot == null) {
            throw new CommandException((ITextComponent)new StringTextComponent("Plot not found: " + plotId));
        }
        return plot;
    }

    private static void sendKeyValuePair(CommandSource source, String label, ITextComponent value) {
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new StringTextComponent(label + ": ").func_240699_a_(TextFormatting.BOLD)).func_230529_a_(value), true);
    }

    private static void sendKeyValuePair(CommandSource source, String label, String value) {
        SpatialStorageCommand.sendKeyValuePair(source, label, (ITextComponent)new StringTextComponent(value));
    }

    private static SpatialStoragePlot getCurrentPlot(CommandSource source) {
        if (source.func_197023_e().func_234923_W_() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new CommandException((ITextComponent)new StringTextComponent("Must be within the spatial storage world."));
        }
        BlockPos playerPos = new BlockPos(source.func_197036_d());
        int x = playerPos.func_177958_n();
        int z = playerPos.func_177952_p();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            BlockPos origin = plot.getOrigin();
            BlockPos size = plot.getSize();
            if (x < origin.func_177958_n() || x > origin.func_177958_n() + size.func_177958_n() || z < origin.func_177952_p() || z > origin.func_177952_p() + size.func_177952_p()) continue;
            return plot;
        }
        throw new CommandException((ITextComponent)new StringTextComponent("Couldn't find a plot for the current position."));
    }
}

