/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.me.storage.ITickingMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MEMonitorIFluidHandler
implements IMEMonitor<IAEFluidStack>,
ITickingMonitor {
    private final IFluidHandler handler;
    private final IItemList<IAEFluidStack> list = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap();
    private final NavigableMap<Integer, CachedFluidStack> memory;
    private IActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;

    public MEMonitorIFluidHandler(IFluidHandler handler) {
        this.handler = handler;
        this.memory = new ConcurrentSkipListMap<Integer, CachedFluidStack>();
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        int filled = this.handler.fill(input.getFluidStack(), type.getFluidAction());
        if (filled == 0) {
            return input.copy();
        }
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        if ((long)filled == input.getStackSize()) {
            return null;
        }
        IAEFluidStack o = input.copy();
        o.setStackSize(input.getStackSize() - (long)filled);
        return o;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable type, IActionSource src) {
        FluidStack removed = this.handler.drain(request.getFluidStack(), type.getFluidAction());
        if (removed.isEmpty() || removed.getAmount() == 0) {
            return null;
        }
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        IAEFluidStack o = request.copy();
        o.setStackSize(removed.getAmount());
        return o;
    }

    @Override
    public IStorageChannel getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public TickRateModulation onTick() {
        ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
        this.list.resetStatus();
        int high = 0;
        boolean changed = false;
        int tankCount = this.handler.getTanks();
        for (int tank = 0; tank < tankCount; ++tank) {
            FluidStack oldIS;
            CachedFluidStack old = (CachedFluidStack)this.memory.get(tank);
            high = Math.max(high, tank);
            FluidStack newIS = this.handler.getFluidInTank(tank);
            if (!newIS.isEmpty() && this.getMode() == StorageFilter.EXTRACTABLE_ONLY && this.handler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty() && this.handler.drain(1000, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                newIS = FluidStack.EMPTY;
            }
            FluidStack fluidStack = oldIS = old == null ? FluidStack.EMPTY : old.fluidStack;
            if (MEMonitorIFluidHandler.isDifferent(newIS, oldIS)) {
                CachedFluidStack cis = new CachedFluidStack(newIS);
                this.memory.put(tank, cis);
                if (old != null && old.aeStack != null) {
                    old.aeStack.setStackSize(-old.aeStack.getStackSize());
                    changes.add(old.aeStack);
                }
                if (cis.aeStack != null) {
                    changes.add(cis.aeStack);
                    this.list.add(cis.aeStack);
                }
                changed = true;
                continue;
            }
            int newSize = newIS.isEmpty() ? 0 : newIS.getAmount();
            int diff = newSize - (oldIS.isEmpty() ? 0 : oldIS.getAmount());
            IAEStack stack = null;
            if (!newIS.isEmpty()) {
                IAEStack<IAEFluidStack> iAEStack = stack = old == null || old.aeStack == null ? (IAEFluidStack)Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createStack(newIS) : old.aeStack.copy();
            }
            if (stack != null) {
                stack.setStackSize(newSize);
                this.list.add((IAEFluidStack)stack);
            }
            if (diff == 0 || stack == null) continue;
            CachedFluidStack cis = new CachedFluidStack(newIS);
            this.memory.put(tank, cis);
            IAEFluidStack a = stack.copy();
            a.setStackSize(diff);
            changes.add(a);
            changed = true;
        }
        NavigableMap<Integer, CachedFluidStack> end = this.memory.tailMap(high, false);
        if (!end.isEmpty()) {
            for (CachedFluidStack cis : end.values()) {
                if (cis == null || cis.aeStack == null) continue;
                IAEFluidStack a = cis.aeStack.copy();
                a.setStackSize(-a.getStackSize());
                changes.add(a);
                changed = true;
            }
            end.clear();
        }
        if (!changes.isEmpty()) {
            this.postDifference(changes);
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private static boolean isDifferent(FluidStack a, FluidStack b) {
        if (a == b) {
            return false;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return true;
        }
        return !a.getFluid().equals(b.getFluid());
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEFluidStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEFluidStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList out) {
        for (CachedFluidStack is : this.memory.values()) {
            out.addStorage(is.aeStack);
        }
        return out;
    }

    @Override
    public IItemList<IAEFluidStack> getStorageList() {
        return this.list;
    }

    private StorageFilter getMode() {
        return this.mode;
    }

    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private IActionSource getActionSource() {
        return this.mySource;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }

    private static class CachedFluidStack {
        private final FluidStack fluidStack;
        private final IAEFluidStack aeStack;

        CachedFluidStack(FluidStack is) {
            if (is.isEmpty()) {
                this.fluidStack = FluidStack.EMPTY;
                this.aeStack = null;
            } else {
                this.fluidStack = is.copy();
                this.aeStack = (IAEFluidStack)Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createStack(is);
            }
        }
    }
}

