/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellContainer;
import appeng.api.storage.cells.ICellProvider;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.me.cache.NetworkMonitor;
import appeng.me.cache.SecurityCache;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.GenericInterestManager;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.ItemWatcher;
import appeng.me.storage.NetworkInventoryHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class GridStorageCache
implements IStorageGrid {
    private final IGrid myGrid;
    private final HashSet<ICellProvider> activeCellProviders = new HashSet();
    private final HashSet<ICellProvider> inactiveCellProviders = new HashSet();
    private final SetMultimap<IAEStack, ItemWatcher> interests = HashMultimap.create();
    private final GenericInterestManager<ItemWatcher> interestManager = new GenericInterestManager<ItemWatcher>((Multimap<IAEStack, ItemWatcher>)this.interests);
    private final HashMap<IGridNode, IStackWatcher> watchers = new HashMap();
    private Map<IStorageChannel<? extends IAEStack>, NetworkInventoryHandler<?>> storageNetworks;
    private Map<IStorageChannel<? extends IAEStack>, NetworkMonitor<?>> storageMonitors;

    public GridStorageCache(IGrid g) {
        this.myGrid = g;
        this.storageNetworks = new IdentityHashMap();
        this.storageMonitors = new IdentityHashMap();
        Api.instance().storage().storageChannels().forEach(channel -> this.storageMonitors.put((IStorageChannel<IAEStack>)channel, new NetworkMonitor(this, channel)));
    }

    @Override
    public void onUpdateTick() {
        this.storageMonitors.forEach((channel, monitor) -> monitor.onTick());
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        IStackWatcher myWatcher;
        if (machine instanceof ICellContainer) {
            ICellContainer cc = (ICellContainer)((Object)machine);
            CellChangeTracker tracker = new CellChangeTracker();
            this.removeCellProvider(cc, tracker);
            this.inactiveCellProviders.remove(cc);
            this.getGrid().postEvent(new MENetworkCellArrayUpdate());
            tracker.applyChanges();
        }
        if (machine instanceof IStackWatcherHost && (myWatcher = this.watchers.get(machine)) != null) {
            myWatcher.reset();
            this.watchers.remove(machine);
        }
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        if (machine instanceof ICellContainer) {
            ICellContainer cc = (ICellContainer)((Object)machine);
            this.inactiveCellProviders.add(cc);
            this.getGrid().postEvent(new MENetworkCellArrayUpdate());
            if (node.isActive()) {
                CellChangeTracker tracker = new CellChangeTracker();
                this.addCellProvider(cc, tracker);
                tracker.applyChanges();
            }
        }
        if (machine instanceof IStackWatcherHost) {
            IStackWatcherHost swh = (IStackWatcherHost)((Object)machine);
            ItemWatcher iw = new ItemWatcher(this, swh);
            this.watchers.put(node, iw);
            swh.updateWatcher(iw);
        }
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    public <T extends IAEStack<T>> IMEInventoryHandler<T> getInventoryHandler(IStorageChannel<T> channel) {
        return this.storageNetworks.computeIfAbsent(channel, this::buildNetworkStorage);
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        return this.storageMonitors.get(channel);
    }

    private CellChangeTracker addCellProvider(ICellProvider cc, CellChangeTracker tracker) {
        if (this.inactiveCellProviders.contains(cc)) {
            this.inactiveCellProviders.remove(cc);
            this.activeCellProviders.add(cc);
            IActionSource actionSrc = cc instanceof IActionHost ? new MachineSource((IActionHost)((Object)cc)) : new BaseActionSource();
            this.storageMonitors.forEach((channel, monitor) -> {
                for (IMEInventoryHandler h : cc.getCellArray((IStorageChannel<?>)channel)) {
                    tracker.postChanges(channel, 1, h, actionSrc);
                }
            });
        }
        return tracker;
    }

    private CellChangeTracker removeCellProvider(ICellProvider cc, CellChangeTracker tracker) {
        if (this.activeCellProviders.contains(cc)) {
            this.activeCellProviders.remove(cc);
            this.inactiveCellProviders.add(cc);
            IActionSource actionSrc = cc instanceof IActionHost ? new MachineSource((IActionHost)((Object)cc)) : new BaseActionSource();
            this.storageMonitors.forEach((channel, monitor) -> {
                for (IMEInventoryHandler h : cc.getCellArray((IStorageChannel<?>)channel)) {
                    tracker.postChanges(channel, -1, h, actionSrc);
                }
            });
        }
        return tracker;
    }

    @MENetworkEventSubscribe
    public void cellUpdate(MENetworkCellArrayUpdate ev) {
        this.storageNetworks.clear();
        ArrayList<ICellProvider> ll = new ArrayList<ICellProvider>();
        ll.addAll(this.inactiveCellProviders);
        ll.addAll(this.activeCellProviders);
        CellChangeTracker tracker = new CellChangeTracker();
        for (ICellProvider cc : ll) {
            boolean active = true;
            if (cc instanceof IActionHost) {
                IGridNode node = ((IActionHost)((Object)cc)).getActionableNode();
                active = node != null && node.isActive();
            }
            if (active) {
                this.addCellProvider(cc, tracker);
                continue;
            }
            this.removeCellProvider(cc, tracker);
        }
        this.storageMonitors.forEach((channel, monitor) -> monitor.forceUpdate());
        tracker.applyChanges();
    }

    private <T extends IAEStack<T>, C extends IStorageChannel<T>> void postChangesToNetwork(C chan, int upOrDown, IItemList<T> availableItems, IActionSource src) {
        this.storageMonitors.get(chan).postChange(upOrDown > 0, availableItems, src);
    }

    private <T extends IAEStack<T>, C extends IStorageChannel<T>> NetworkInventoryHandler<T> buildNetworkStorage(C chan) {
        SecurityCache security = (SecurityCache)this.getGrid().getCache(ISecurityGrid.class);
        NetworkInventoryHandler storageNetwork = new NetworkInventoryHandler(chan, security);
        for (ICellProvider cc : this.activeCellProviders) {
            for (IMEInventoryHandler h : cc.getCellArray(chan)) {
                storageNetwork.addNewStorage(h);
            }
        }
        return storageNetwork;
    }

    @Override
    public void postAlterationOfStoredItems(IStorageChannel<?> chan, Iterable<? extends IAEStack<?>> input, IActionSource src) {
        this.storageMonitors.get(chan).postChange(true, input, src);
    }

    @Override
    public void registerCellProvider(ICellProvider provider) {
        this.inactiveCellProviders.add(provider);
        this.addCellProvider(provider, new CellChangeTracker()).applyChanges();
    }

    @Override
    public void unregisterCellProvider(ICellProvider provider) {
        this.removeCellProvider(provider, new CellChangeTracker()).applyChanges();
        this.inactiveCellProviders.remove(provider);
    }

    public GenericInterestManager<ItemWatcher> getInterestManager() {
        return this.interestManager;
    }

    IGrid getGrid() {
        return this.myGrid;
    }

    private class CellChangeTracker<T extends IAEStack<T>> {
        final List<CellChangeTrackerRecord<T>> data = new ArrayList<CellChangeTrackerRecord<T>>();

        private CellChangeTracker() {
        }

        public void postChanges(IStorageChannel<T> channel, int i, IMEInventoryHandler<T> h, IActionSource actionSrc) {
            this.data.add(new CellChangeTrackerRecord<T>(channel, i, h, actionSrc));
        }

        public void applyChanges() {
            for (CellChangeTrackerRecord<T> rec : this.data) {
                rec.applyChanges();
            }
        }
    }

    private class CellChangeTrackerRecord<T extends IAEStack<T>> {
        final IStorageChannel<T> channel;
        final int up_or_down;
        final IItemList<T> list;
        final IActionSource src;

        public CellChangeTrackerRecord(IStorageChannel<T> channel, int i, IMEInventoryHandler<T> h, IActionSource actionSrc) {
            this.channel = channel;
            this.up_or_down = i;
            this.src = actionSrc;
            this.list = h.getAvailableItems(channel.createList());
        }

        public void applyChanges() {
            GridStorageCache.this.postChangesToNetwork(this.channel, this.up_or_down, this.list, this.src);
        }
    }
}

