/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.AEColor;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MemoryCardItem
extends AEBaseItem
implements IMemoryCard {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public MemoryCardItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        String firstLineKey = this.getFirstValidTranslationKey(this.getSettingsName(stack) + ".name", this.getSettingsName(stack));
        lines.add((ITextComponent)new TranslationTextComponent(firstLineKey));
        CompoundNBT data = this.getData(stack);
        if (data.func_74764_b("tooltip")) {
            String tooltipKey = this.getFirstValidTranslationKey(data.func_74779_i("tooltip") + ".name", data.func_74779_i("tooltip"));
            lines.add((ITextComponent)new TranslationTextComponent(tooltipKey));
        }
        if (data.func_74764_b("freq")) {
            short freq = data.func_74765_d("freq");
            String freqTooltip = TextFormatting.BOLD + Platform.p2p().toHexString(freq);
            lines.add((ITextComponent)new TranslationTextComponent("gui.tooltips.appliedenergistics2.P2PFrequency", new Object[]{freqTooltip}));
        }
    }

    private String getFirstValidTranslationKey(String ... name) {
        for (String n3 : name) {
            if (!I18n.func_188566_a((String)n3)) continue;
            return n3;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, CompoundNBT data) {
        CompoundNBT c = is.func_196082_o();
        c.func_74778_a("Config", settingsName);
        c.func_218657_a("Data", (INBT)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        CompoundNBT c = is.func_196082_o();
        String name = c.func_74779_i("Config");
        return name.isEmpty() ? GuiText.Blank.getTranslationKey() : name;
    }

    @Override
    public CompoundNBT getData(ItemStack is) {
        CompoundNBT c = is.func_196082_o();
        CompoundNBT o = c.func_74775_l("Data");
        return o.func_74737_b();
    }

    @Override
    public AEColor[] getColorCode(ItemStack is) {
        CompoundNBT tag = this.getData(is);
        if (tag.func_74764_b("colorCode")) {
            int[] frequency = tag.func_74759_k("colorCode");
            AEColor[] colorArray = AEColor.values();
            return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(PlayerEntity player, MemoryCardMessages msg) {
        if (player.func_130014_f_().func_201670_d()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.func_145747_a(PlayerMessages.SettingCleared.get(), Util.field_240973_b_);
                break;
            }
            case INVALID_MACHINE: {
                player.func_145747_a(PlayerMessages.InvalidMachine.get(), Util.field_240973_b_);
                break;
            }
            case SETTINGS_LOADED: {
                player.func_145747_a(PlayerMessages.LoadedSettings.get(), Util.field_240973_b_);
                break;
            }
            case SETTINGS_SAVED: {
                player.func_145747_a(PlayerMessages.SavedSettings.get(), Util.field_240973_b_);
                break;
            }
            case SETTINGS_RESET: {
                player.func_145747_a(PlayerMessages.ResetSettings.get(), Util.field_240973_b_);
                break;
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (InteractionUtil.isInAlternateUseMode(context.func_195999_j())) {
            World w = context.func_195991_k();
            if (!w.func_201670_d()) {
                this.clearCard(context.func_195999_j(), context.func_195991_k(), context.func_221531_n());
            }
            return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity player, Hand hand) {
        if (InteractionUtil.isInAlternateUseMode(player) && !w.field_72995_K) {
            this.clearCard(player, w, hand);
        }
        return super.func_77659_a(w, player, hand);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    private void clearCard(PlayerEntity player, World w, Hand hand) {
        IMemoryCard mem = (IMemoryCard)player.func_184586_b(hand).func_77973_b();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.func_184586_b(hand).func_77982_d(null);
    }
}

