/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEColor;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.hooks.ticking.PlayerColor;
import appeng.hooks.ticking.TickHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class PaintedEntityPacket
extends BasePacket {
    private final AEColor myColor;
    private final int entityId;
    private int ticks;

    public PaintedEntityPacket(PacketBuffer stream) {
        this.entityId = stream.readInt();
        this.myColor = AEColor.values()[stream.readByte()];
        this.ticks = stream.readInt();
    }

    public PaintedEntityPacket(int myEntity, AEColor myColor, int ticksLeft) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.entityId = myEntity;
        data.writeInt(this.entityId);
        this.myColor = myColor;
        data.writeByte(this.myColor.ordinal());
        data.writeInt(ticksLeft);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        PlayerColor pc = new PlayerColor(this.entityId, this.myColor, this.ticks);
        TickHandler.instance().getPlayerColors().put(this.entityId, pc);
    }
}

