/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.AEAddon;
import appeng.api.IAEAddon;
import appeng.api.IAppEngApi;
import appeng.core.AELog;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

class AddonLoader {
    AddonLoader() {
    }

    public static void loadAddons(IAppEngApi api) {
        Type annotationType = Type.getType(AEAddon.class);
        List allScanData = ModList.get().getAllScanData();
        allScanData.stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> Objects.equals(a.getAnnotationType(), annotationType)).map(ModFileScanData.AnnotationData::getMemberName).forEach(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                Class<IAEAddon> instanceClass = clazz.asSubclass(IAEAddon.class);
                IAEAddon instance = instanceClass.newInstance();
                instance.onAPIAvailable(api);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                AELog.error("Failed to load: %s", className, e);
                throw new RuntimeException(e);
            }
        });
    }
}

