/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.me.common.IncrementalUpdateHelper;
import appeng.container.me.crafting.CraftingStatusEntry;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class CraftingStatus {
    public static final CraftingStatus EMPTY = new CraftingStatus(true, 0L, 0L, 0L, Collections.emptyList());
    private final boolean fullStatus;
    private final long elapsedTime;
    private final long remainingItemCount;
    private final long startItemCount;
    private final List<CraftingStatusEntry> entries;

    public CraftingStatus(boolean fullStatus, long elapsedTime, long remainingItemCount, long startItemCount, List<CraftingStatusEntry> entries) {
        this.fullStatus = fullStatus;
        this.elapsedTime = elapsedTime;
        this.remainingItemCount = remainingItemCount;
        this.startItemCount = startItemCount;
        this.entries = ImmutableList.copyOf(entries);
    }

    public boolean isFullStatus() {
        return this.fullStatus;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    public long getStartItemCount() {
        return this.startItemCount;
    }

    public List<CraftingStatusEntry> getEntries() {
        return this.entries;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.fullStatus);
        buffer.func_179254_b(this.elapsedTime);
        buffer.func_179254_b(this.remainingItemCount);
        buffer.func_179254_b(this.startItemCount);
        buffer.func_150787_b(this.entries.size());
        for (CraftingStatusEntry entry : this.entries) {
            entry.write(buffer);
        }
    }

    public static CraftingStatus read(PacketBuffer buffer) {
        boolean fullStatus = buffer.readBoolean();
        long elapsedTime = buffer.func_179260_f();
        long remainingItemCount = buffer.func_179260_f();
        long startItemCount = buffer.func_179260_f();
        int entryCount = buffer.func_150792_a();
        ImmutableList.Builder entries = ImmutableList.builder();
        for (int i = 0; i < entryCount; ++i) {
            entries.add((Object)CraftingStatusEntry.read(buffer));
        }
        return new CraftingStatus(fullStatus, elapsedTime, remainingItemCount, startItemCount, (List<CraftingStatusEntry>)entries.build());
    }

    public static CraftingStatus create(IncrementalUpdateHelper<IAEItemStack> changes, CraftingCPUCluster cpu) {
        boolean full = changes.isFullUpdate();
        ImmutableList.Builder newEntries = ImmutableList.builder();
        for (IAEItemStack stack : changes) {
            IAEItemStack stored = cpu.getItemStack(stack, CraftingItemList.STORAGE);
            IAEItemStack active = cpu.getItemStack(stack, CraftingItemList.ACTIVE);
            IAEItemStack pending = cpu.getItemStack(stack, CraftingItemList.PENDING);
            long storedCount = stored != null ? stored.getStackSize() : 0L;
            long activeCount = active != null ? active.getStackSize() : 0L;
            long pendingCount = pending != null ? pending.getStackSize() : 0L;
            ItemStack item = stack.getDefinition();
            if (!full && changes.getSerial(stack) != null) {
                item = ItemStack.field_190927_a;
            }
            newEntries.add((Object)new CraftingStatusEntry(changes.getOrAssignSerial(stack), item, storedCount, activeCount, pendingCount));
        }
        long elapsedTime = cpu.getElapsedTime();
        long remainingItems = cpu.getRemainingItemCount();
        long startItems = cpu.getStartItemCount();
        return new CraftingStatus(full, elapsedTime, remainingItems, startItems, (List<CraftingStatusEntry>)newEntries.build());
    }
}

