/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.me.crafting.CraftingPlanSummaryEntry;
import appeng.core.Api;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class CraftingPlanSummary {
    private final long usedBytes;
    private final boolean simulation;
    private final List<CraftingPlanSummaryEntry> entries;

    public CraftingPlanSummary(long usedBytes, boolean simulation, List<CraftingPlanSummaryEntry> entries) {
        this.usedBytes = usedBytes;
        this.simulation = simulation;
        this.entries = entries;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public List<CraftingPlanSummaryEntry> getEntries() {
        return this.entries;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179254_b(this.usedBytes);
        buffer.writeBoolean(this.simulation);
        buffer.func_150787_b(this.entries.size());
        for (CraftingPlanSummaryEntry entry : this.entries) {
            entry.write(buffer);
        }
    }

    public static CraftingPlanSummary read(PacketBuffer buffer) {
        long bytesUsed = buffer.func_179260_f();
        boolean simulation = buffer.readBoolean();
        int entryCount = buffer.func_150792_a();
        ImmutableList.Builder entries = ImmutableList.builder();
        for (int i = 0; i < entryCount; ++i) {
            entries.add((Object)CraftingPlanSummaryEntry.read(buffer));
        }
        return new CraftingPlanSummary(bytesUsed, simulation, (List<CraftingPlanSummaryEntry>)entries.build());
    }

    public static CraftingPlanSummary fromJob(IGrid grid, IActionSource actionSource, ICraftingJob job) {
        IItemList<IAEItemStack> plan = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        job.populatePlan(plan);
        ImmutableList.Builder entries = ImmutableList.builder();
        IStorageGrid sg = (IStorageGrid)grid.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> items = sg.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        for (IAEItemStack out : plan) {
            long missingAmount;
            long storedAmount;
            if (job.isSimulation()) {
                IAEItemStack available = items.extractItems(out.copy(), Actionable.SIMULATE, actionSource);
                storedAmount = available == null ? 0L : available.getStackSize();
                missingAmount = out.getStackSize() - storedAmount;
            } else {
                storedAmount = out.getStackSize();
                missingAmount = 0L;
            }
            long craftAmount = out.getCountRequestable();
            entries.add((Object)new CraftingPlanSummaryEntry(out.asItemStackRepresentation(), missingAmount, storedAmount, craftAmount));
        }
        return new CraftingPlanSummary(job.getByteTotal(), job.isSimulation(), (List<CraftingPlanSummaryEntry>)entries.build());
    }
}

